/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.rrd4j.core.InvalidRrdException;
import org.rrd4j.core.jrrd.Constants;
import org.rrd4j.core.jrrd.UnivalArray;

class RRDFile
implements Constants {
    private static final byte[] FLOAT_COOKIE_BIG_ENDIAN = new byte[]{91, 31, 43, 67, -57, -64, 37, 47};
    private static final byte[] FLOAT_COOKIE_LITTLE_ENDIAN = new byte[]{47, 37, -64, -57, 67, 43, 31, 91};
    private int alignment;
    private int longSize = 4;
    private final FileInputStream underlying;
    private final MappedByteBuffer mappedByteBuffer;
    private ByteOrder order;

    RRDFile(String name) throws IOException {
        this(new File(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RRDFile(File file) throws IOException {
        long len = file.length();
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("RRDFile cannot read files larger than 2**31 because of limitations of java.nio.ByteBuffer");
        }
        boolean ok = false;
        try {
            this.underlying = new FileInputStream(file);
            this.mappedByteBuffer = this.underlying.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, len);
            this.initDataLayout(file);
            ok = true;
        }
        finally {
            if (!ok) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void initDataLayout(File file) throws IOException {
        if (file.exists()) {
            byte[] buffer = new byte[32];
            this.mappedByteBuffer.get(buffer);
            ByteBuffer bbuffer = ByteBuffer.wrap(buffer);
            int index = this.indexOf(FLOAT_COOKIE_BIG_ENDIAN, buffer);
            if (index != -1) {
                this.order = ByteOrder.BIG_ENDIAN;
            } else {
                index = this.indexOf(FLOAT_COOKIE_LITTLE_ENDIAN, buffer);
                if (index != -1) {
                    this.order = ByteOrder.LITTLE_ENDIAN;
                } else {
                    throw new InvalidRrdException("Invalid RRD file");
                }
            }
            this.mappedByteBuffer.order(this.order);
            bbuffer.order(this.order);
            switch (index) {
                case 12: {
                    this.alignment = 4;
                    break;
                }
                case 16: {
                    this.alignment = 8;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported architecture");
                }
            }
            bbuffer.position(index + 8);
            int int1 = bbuffer.getInt();
            int int2 = bbuffer.getInt();
            if (int1 == 0 || int2 == 0) {
                this.longSize = 8;
            }
        }
        this.mappedByteBuffer.rewind();
    }

    private int indexOf(byte[] pattern, byte[] array) {
        return new String(array).indexOf(new String(pattern));
    }

    boolean isBigEndian() {
        return this.order == ByteOrder.BIG_ENDIAN;
    }

    int getAlignment() {
        return this.alignment;
    }

    double readDouble() {
        return this.mappedByteBuffer.getDouble();
    }

    int readInt() {
        return this.mappedByteBuffer.getInt();
    }

    int readLong() {
        if (this.longSize == 4) {
            return this.mappedByteBuffer.getInt();
        }
        return (int)this.mappedByteBuffer.getLong();
    }

    String readString(int maxLength) {
        byte[] array = new byte[maxLength];
        this.mappedByteBuffer.get(array);
        return new String(array, 0, maxLength).trim();
    }

    void skipBytes(int n) {
        this.mappedByteBuffer.position(this.mappedByteBuffer.position() + n);
    }

    int align(int boundary) {
        int skip = (boundary - this.mappedByteBuffer.position() % boundary) % boundary;
        if (skip != 0) {
            this.mappedByteBuffer.position(this.mappedByteBuffer.position() + skip);
        }
        return skip;
    }

    int align() {
        return this.align(this.alignment);
    }

    long info() {
        return this.mappedByteBuffer.position();
    }

    long getFilePointer() {
        return this.mappedByteBuffer.position();
    }

    void close() throws IOException {
        if (this.underlying != null) {
            this.underlying.close();
        }
    }

    void read(ByteBuffer bb) {
        int count = bb.remaining();
        bb.put(this.mappedByteBuffer.duplicate().limit(this.mappedByteBuffer.position() + count));
        this.mappedByteBuffer.position(this.mappedByteBuffer.position() + count);
    }

    UnivalArray getUnivalArray(int size) {
        return new UnivalArray(this, size);
    }

    int getBits() {
        return this.longSize * 8;
    }

    public void seek(long position) {
        this.mappedByteBuffer.position((int)position);
    }

    public void seekToEndOfFile() {
        this.mappedByteBuffer.position(this.mappedByteBuffer.limit());
    }
}

