/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class I2PRequestLog
extends AbstractLifeCycle
implements RequestLog {
    private String _filename;
    private boolean _extended = true;
    private boolean _append = true;
    private int _retainDays = 31;
    private boolean _closeOut;
    private boolean _preferProxiedForAddress;
    private String _logDateFormat = "dd/MMM/yyyy:HH:mm:ss Z";
    private String _filenameDateFormat = null;
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = "GMT";
    private String[] _ignorePaths;
    private boolean _logLatency = false;
    private boolean _logCookies = false;
    private boolean _logServer = false;
    private boolean _b64;
    private transient OutputStream _out;
    private transient OutputStream _fileOut;
    private transient DateCache _logDateCache;
    private transient Writer _writer;

    public I2PRequestLog() {
    }

    public I2PRequestLog(String filename) {
        this.setFilename(filename);
    }

    public void setFilename(String filename) {
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        this._filename = filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._fileOut instanceof RolloverFileOutputStream) {
            return ((RolloverFileOutputStream)this._fileOut).getDatedFilename();
        }
        return null;
    }

    public void setLogDateFormat(String format) {
        this._logDateFormat = format;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogLocale(Locale logLocale) {
        this._logLocale = logLocale;
    }

    public Locale getLogLocale() {
        return this._logLocale;
    }

    public void setLogTimeZone(String tz) {
        this._logTimeZone = tz;
    }

    public String getLogTimeZone() {
        return this._logTimeZone;
    }

    public void setRetainDays(int retainDays) {
        this._retainDays = retainDays;
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setExtended(boolean extended) {
        this._extended = extended;
    }

    public boolean isExtended() {
        return this._extended;
    }

    public void setAppend(boolean append) {
        this._append = append;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setIgnorePaths(String[] ignorePaths) {
        this._ignorePaths = ignorePaths;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    public void setLogCookies(boolean logCookies) {
        this._logCookies = logCookies;
    }

    public boolean getLogCookies() {
        return this._logCookies;
    }

    public boolean getLogServer() {
        return this._logServer;
    }

    public void setLogServer(boolean logServer) {
        this._logServer = logServer;
    }

    public void setLogLatency(boolean logLatency) {
        this._logLatency = logLatency;
    }

    public boolean getLogLatency() {
        return this._logLatency;
    }

    public void setPreferProxiedForAddress(boolean preferProxiedForAddress) {
        this._preferProxiedForAddress = preferProxiedForAddress;
    }

    public void setB64(boolean b64) {
        this._b64 = b64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Request request, Response response) {
        block31: {
            if (!this.isStarted()) {
                return;
            }
            try {
                if (this._fileOut == null) {
                    return;
                }
                StringBuilder buf = new StringBuilder(160);
                if (this._logServer) {
                    buf.append(Request.getServerName((Request)request));
                    buf.append(' ');
                }
                Object addr = null;
                if (this._preferProxiedForAddress) {
                    addr = request.getHeaders().get("X-Forwarded-For");
                }
                if (addr == null) {
                    if (this._b64) {
                        addr = request.getHeaders().get("X-I2P-DestHash");
                        if (addr != null) {
                            addr = (String)addr + ".i2p";
                        }
                    } else {
                        addr = request.getHeaders().get("X-I2P-DestB32");
                    }
                    if (addr == null) {
                        addr = Request.getRemoteAddr((Request)request);
                    }
                }
                buf.append((String)addr);
                buf.append(" - ");
                String user = request.getHttpURI().getUser();
                buf.append(user == null ? " - " : user);
                buf.append(" [");
                if (this._logDateCache != null) {
                    buf.append(this._logDateCache.format(Request.getTimeStamp((Request)request)));
                } else {
                    buf.append(Request.getTimeStamp((Request)request));
                }
                buf.append("] \"");
                buf.append(request.getMethod());
                buf.append(' ');
                buf.append(request.getHttpURI().getPathQuery());
                buf.append(' ');
                buf.append(request.getConnectionMetaData().getProtocol());
                buf.append("\" ");
                int status = response.getStatus();
                if (status <= 0) {
                    status = 404;
                }
                buf.append((char)(48 + status / 100 % 10));
                buf.append((char)(48 + status / 10 % 10));
                buf.append((char)(48 + status % 10));
                long responseLength = Response.getContentBytesWritten((Response)response);
                if (responseLength >= 0L) {
                    buf.append(' ');
                    if (responseLength > 99999L) {
                        buf.append(Long.toString(responseLength));
                    } else {
                        if (responseLength > 9999L) {
                            buf.append((char)(48L + responseLength / 10000L % 10L));
                        }
                        if (responseLength > 999L) {
                            buf.append((char)(48L + responseLength / 1000L % 10L));
                        }
                        if (responseLength > 99L) {
                            buf.append((char)(48L + responseLength / 100L % 10L));
                        }
                        if (responseLength > 9L) {
                            buf.append((char)(48L + responseLength / 10L % 10L));
                        }
                        buf.append((char)(48L + responseLength % 10L));
                    }
                    buf.append(' ');
                } else {
                    buf.append(" - ");
                }
                if (!(this._extended || this._logCookies || this._logLatency)) {
                    Writer writer = this._writer;
                    synchronized (writer) {
                        buf.append(System.getProperty("line.separator", "\n"));
                        this._writer.write(buf.toString());
                        this._writer.flush();
                        break block31;
                    }
                }
                Writer writer = this._writer;
                synchronized (writer) {
                    this._writer.write(buf.toString());
                    if (this._extended) {
                        this.logExtended(request, response, this._writer);
                    }
                    if (this._logLatency) {
                        this._writer.write(32);
                        this._writer.write(Long.toString(System.currentTimeMillis() - Request.getTimeStamp((Request)request)));
                    }
                    this._writer.write(System.getProperty("line.separator", "\n"));
                    this._writer.flush();
                }
            }
            catch (IOException e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
    }

    protected void logExtended(Request request, Response response, Writer writer) throws IOException {
        String referer = request.getHeaders().get("Referer");
        if (referer == null) {
            writer.write("\"-\" ");
        } else {
            writer.write(34);
            writer.write(referer);
            writer.write("\" ");
        }
        String agent = request.getHeaders().get("User-Agent");
        if (agent == null) {
            writer.write("\"-\" ");
        } else {
            writer.write(34);
            writer.write(agent);
            writer.write(34);
        }
    }

    protected void doStart() throws Exception {
        if (this._logDateFormat != null) {
            this._logDateCache = new DateCache(this._logDateFormat, this._logLocale, this._logTimeZone);
        }
        if (this._filename != null) {
            this._fileOut = new RolloverFileOutputStream(this._filename, this._append, this._retainDays, TimeZone.getTimeZone(this._logTimeZone), this._filenameDateFormat, null);
            this._closeOut = true;
        } else {
            this._fileOut = System.err;
        }
        this._out = this._fileOut;
        this._writer = new OutputStreamWriter(this._out, "UTF-8");
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        try {
            if (this._writer != null) {
                this._writer.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._out != null && this._closeOut) {
            try {
                this._out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._out = null;
        this._fileOut = null;
        this._closeOut = false;
        this._logDateCache = null;
        this._writer = null;
    }

    public String getFilenameDateFormat() {
        return this._filenameDateFormat;
    }

    public void setFilenameDateFormat(String logFileDateFormat) {
        this._filenameDateFormat = logFileDateFormat;
    }
}

