/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.event.WrapperControlEvent;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;
import org.tanukisoftware.wrapper.event.WrapperServiceControlEvent;

class WrapperListener {
    private final WrapperEventListener _listener;
    private static final String PROP_GRACEFUL_HUP = "router.gracefulHUP";

    public WrapperListener(RouterContext ctx) {
        this._listener = new SignalHandler(ctx);
        long mask = SystemVersion.isWindows() ? 1L : 2L;
        WrapperManager.addWrapperEventListener((WrapperEventListener)this._listener, (long)mask);
    }

    public void unregister() {
        WrapperManager.removeWrapperEventListener((WrapperEventListener)this._listener);
    }

    private static class SignalHandler
    implements WrapperEventListener {
        private final RouterContext _ctxt;

        public SignalHandler(RouterContext ctx) {
            this._ctxt = ctx;
        }

        public void fired(WrapperEvent event) {
            Log log = this._ctxt.logManager().getLog(ConfigServiceHandler.class);
            if (SystemVersion.isWindows() && event instanceof WrapperServiceControlEvent) {
                WrapperServiceControlEvent wcse = (WrapperServiceControlEvent)event;
                int code = wcse.getServiceControlCode();
                switch (code) {
                    case 1: 
                    case 5: {
                        log.log(50, "Hard shutdown initiated by Windows service control: " + code);
                        ConfigServiceHandler.registerWrapperNotifier(this._ctxt, 3, false);
                        this._ctxt.router().shutdown(3);
                        break;
                    }
                    default: {
                        if (!log.shouldWarn()) break;
                        log.warn("Unhandled control event code: " + code);
                    }
                }
                return;
            }
            if (!(event instanceof WrapperControlEvent)) {
                if (log.shouldWarn()) {
                    log.warn("Got unhandled event: " + String.valueOf(event));
                }
                return;
            }
            WrapperControlEvent wce = (WrapperControlEvent)event;
            if (log.shouldLog(30)) {
                log.warn("Got signal: " + wce.getControlEventName());
            }
            int sig = wce.getControlEvent();
            switch (sig) {
                case 205: {
                    if (this._ctxt.getBooleanPropertyDefaultTrue(WrapperListener.PROP_GRACEFUL_HUP)) {
                        wce.consume();
                        if (this._ctxt.router().gracefulShutdownInProgress() || this._ctxt.router().isFinalShutdownInProgress()) break;
                        System.err.println("WARN: Graceful shutdown initiated by SIGHUP");
                        log.logAlways(30, "Graceful shutdown initiated by SIGHUP");
                        ConfigServiceHandler.registerWrapperNotifier(this._ctxt, 2, false);
                        this._ctxt.router().shutdownGracefully();
                        break;
                    }
                    log.log(50, "Hard shutdown initiated by SIGHUP");
                }
            }
        }
    }
}

