/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.i2p.I2PAppContext;
import net.i2p.router.web.WebAppStarter;
import org.eclipse.jetty.ee8.nested.SessionHandler;
import org.eclipse.jetty.ee8.servlet.ServletHandler;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class LocaleWebAppHandler
extends Handler.Wrapper {
    private final I2PAppContext _context;
    private final WebAppContext _wac;

    public LocaleWebAppHandler(I2PAppContext ctx, String path, String warPath, File tmpdir, ServletHandler servletHandler) {
        this._context = ctx;
        this._wac = new WebAppContext(warPath, path);
        this.setInitParams(WebAppStarter.INIT_PARAMS);
        this._wac.setTempDirectory(tmpdir);
        this._wac.setExtractWAR(false);
        this._wac.setSessionHandler(new SessionHandler());
        this._wac.setServletHandler(servletHandler);
        this.setHandler((Supplier)this._wac);
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String pathInContext = Request.getPathInContext((Request)request);
        Object newPath = pathInContext;
        if (pathInContext.equals("/") || pathInContext.equals("/index.html")) {
            newPath = "/index.jsp";
        } else if (!(pathInContext.equals("/favicon.ico") || pathInContext.indexOf(47, 1) >= 0 || pathInContext.endsWith(".jsp") || pathInContext.endsWith(".log") || pathInContext.endsWith(".txt"))) {
            newPath = (String)newPath + ".jsp";
        }
        if (pathInContext.equals("/help.jsp")) {
            int len = pathInContext.length();
            if (len < 8 || pathInContext.charAt(len - 7) != '_') {
                String lang = this._context.getProperty("routerconsole.lang");
                if (lang == null || lang.length() <= 0) {
                    lang = Locale.getDefault().getLanguage();
                }
                if (lang != null && lang.length() > 0 && !lang.equals("en")) {
                    String servletPath;
                    String testPath = pathInContext.substring(0, len - 4) + "_" + lang + ".jsp";
                    MatchedResource servlet = this._wac.getServletHandler().getMatchedServlet(testPath);
                    if (servlet != null && (servletPath = servlet.getPathSpec().getDeclaration()) != null && !servletPath.startsWith("*")) {
                        newPath = testPath;
                    }
                }
            }
        } else if (pathInContext.startsWith("/js/")) {
            response.getHeaders().put("Content-Type", "text/javascript;charset=iso-8859-1");
        } else if (pathInContext.endsWith(".css")) {
            response.getHeaders().put("Content-Type", "text/css;charset=utf-8");
        }
        if (!((String)newPath).equals(pathInContext)) {
            request = Request.serveAs((Request)request, (HttpURI)Request.newHttpURIFrom((Request)request, (String)newPath));
        }
        return super.handle(request, response, callback);
    }

    private void setInitParams(Map<?, ?> params) {
        LocaleWebAppHandler.setInitParams(this._wac, params);
    }

    public static void setInitParams(WebAppContext context, Map<?, ?> params) {
        for (Map.Entry<?, ?> e : params.entrySet()) {
            context.setInitParameter((String)e.getKey(), (String)e.getValue());
        }
    }

    public WebAppContext getWebAppContext() {
        return this._wac;
    }
}

