/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.CSSHelper;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.Messages;
import net.i2p.servlet.RequestWrapper;
import net.i2p.util.Log;

public abstract class FormHandler {
    protected RouterContext _context;
    protected Log _log;
    protected Map _settings;
    protected RequestWrapper _requestWrapper;
    private String _nonce;
    private String _nonce1;
    private String _nonce2;
    protected String _action;
    protected String _method;
    private final List<String> _errors = new ArrayList<String>();
    private final List<String> _notices = new ArrayList<String>();
    private boolean _processed;
    private boolean _valid = true;
    protected Writer _out;

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
            this._log = this._context.logManager().getLog(this.getClass());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setNonce(String val) {
        this._nonce = val == null ? null : DataHelper.stripHTML(val);
    }

    public void setAction(String val) {
        this._action = val == null ? null : DataHelper.stripHTML(val);
    }

    public void setSettings(Map settings) {
        this._settings = new HashMap(settings);
    }

    public void setRequestWrapper(RequestWrapper rw) {
        this._requestWrapper = rw;
    }

    public boolean isAdvanced() {
        return this._context.getBooleanProperty("routerconsole.advanced");
    }

    protected String getJettyString(String key) {
        if (this._settings == null) {
            return null;
        }
        String[] arr = (String[])this._settings.get(key);
        if (arr == null) {
            return null;
        }
        return arr[0].trim();
    }

    public void storeMethod(String val) {
        this._method = val;
    }

    public void storeWriter(Writer out) {
        this._out = out;
    }

    public void storeNonces(String n1, String n2) {
        this._nonce1 = n1;
        this._nonce2 = n2;
    }

    protected abstract void processForm();

    protected void addFormError(String errorMsg) {
        if (errorMsg == null) {
            return;
        }
        this._errors.add(DataHelper.escapeHTML(errorMsg));
    }

    protected void addFormNotice(String msg) {
        if (msg == null) {
            return;
        }
        this._notices.add(DataHelper.escapeHTML(msg));
    }

    protected void addFormNoticeNoEscape(String msg) {
        if (msg == null) {
            return;
        }
        this._notices.add(msg);
    }

    protected void addFormErrorNoEscape(String msg) {
        if (msg == null) {
            return;
        }
        this._errors.add(msg);
    }

    public String getAllMessages() {
        this.validate();
        this.process();
        if (this._errors.isEmpty() && this._notices.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<div class=\"messages\" id=\"messages\">");
        if (!this._errors.isEmpty()) {
            buf.append("<div class=\"error\">");
            buf.append(FormHandler.render(this._errors));
            buf.append("</div>");
        }
        if (!this._notices.isEmpty()) {
            buf.append("<div class=\"notice\">");
            buf.append(FormHandler.render(this._notices));
            buf.append("</div>");
        }
        buf.append("</div>");
        return buf.toString();
    }

    public String getErrors() {
        this.validate();
        this.process();
        return FormHandler.render(this._errors);
    }

    public String getNotices() {
        this.validate();
        this.process();
        return FormHandler.render(this._notices);
    }

    private void validate() {
        if (this._processed) {
            return;
        }
        this._valid = true;
        if (this._action == null) {
            this._valid = false;
            return;
        }
        if (this._method != null && !"POST".equals(this._method)) {
            this.addFormError("Invalid form submission, requires POST");
            this._valid = false;
            return;
        }
        if (this._nonce == null) {
            this._valid = false;
            return;
        }
        String sharedNonce = CSSHelper.getNonce();
        if (sharedNonce.equals(this._nonce)) {
            return;
        }
        if (!this._nonce.equals(this._nonce1) && !this._nonce.equals(this._nonce2)) {
            this.addFormError(this._t("Invalid form submission, probably because you used the 'back' or 'reload' button on your browser. Please resubmit.") + " " + this._t("If the problem persists, verify that you have cookies enabled in your browser."));
            this._valid = false;
        }
    }

    private void process() {
        if (!this._processed) {
            if (this._valid) {
                this.processForm();
            }
            this._processed = true;
        }
    }

    private static String render(List<String> source) {
        if (source.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<ul>\n");
        for (int i = 0; i < source.size(); ++i) {
            buf.append("<li>");
            buf.append(source.get(i));
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        return buf.toString();
    }

    public String getNewNonce() {
        String rv = Long.toString(this._context.random().nextLong());
        return rv;
    }

    public String _t(String s) {
        return Messages.getString(s, this._context);
    }

    public String _t(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    public String _t(String s, Object o, Object o2) {
        return Messages.getString(s, o, o2, (I2PAppContext)this._context);
    }

    public static String _x(String s) {
        return s;
    }
}

