/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.io.block;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.metanotion.io.RAIFile;
import net.metanotion.io.RandomAccessInterface;
import net.metanotion.io.Serializer;
import net.metanotion.io.block.FreeListBlock;
import net.metanotion.io.block.index.BSkipList;
import net.metanotion.io.data.IdentityBytes;
import net.metanotion.io.data.IntBytes;
import net.metanotion.io.data.StringBytes;
import net.metanotion.io.data.UTF8StringBytes;
import net.metanotion.util.skiplist.SkipIterator;

public class BlockFile
implements Closeable {
    public static final int PAGESIZE = 1024;
    public static final long OFFSET_MOUNTED = 20L;
    public final Log log = I2PAppContext.getGlobalContext().logManager().getLog(BlockFile.class);
    public final RandomAccessInterface file;
    private static final int MAJOR = 1;
    private static final int MINOR = 2;
    private static final int MIN_MAJOR = 1;
    private static final int MIN_MINOR = 1;
    private static final long MAGIC_BASE = 3549362387302744064L;
    private static final long MAGIC = 3549362387302744322L;
    private long magicBytes = 3549362387302744322L;
    public static final int MAGIC_CONT = 1129270868;
    public static final int METAINDEX_PAGE = 2;
    private static final long MAX_LEN = 0x7FFFFFFFFFFL;
    private long fileLen = 2048L;
    private int freeListStart = 0;
    private int mounted = 0;
    public int spanSize = 16;
    private final boolean _wasMounted;
    private final BSkipList<String, Integer> metaIndex;
    private boolean _isClosed;
    private FreeListBlock flb;
    private final HashMap<String, BSkipList> openIndices = new HashMap();

    private void mount() throws IOException {
        this.file.seek(20L);
        this.mounted = 1;
        this.file.writeShort(this.mounted);
    }

    private void writeSuperBlock() throws IOException {
        this.file.seek(0L);
        this.file.writeLong(this.magicBytes);
        this.file.writeLong(this.fileLen);
        this.file.writeInt(this.freeListStart);
        this.file.writeShort(this.mounted);
        this.file.writeShort(this.spanSize);
        this.file.writeInt(1024);
    }

    private void readSuperBlock() throws IOException {
        this.file.seek(0L);
        this.magicBytes = this.file.readLong();
        this.fileLen = this.file.readLong();
        this.freeListStart = this.file.readUnsignedInt();
        this.mounted = this.file.readUnsignedShort();
        this.spanSize = this.file.readUnsignedShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: BlockFile file");
            return;
        }
        boolean init = !new File(args[0]).exists();
        RAIFile raif = null;
        BlockFile bf = null;
        try {
            raif = new RAIFile(new File(args[0]), true, true);
            bf = new BlockFile(raif, init);
            bf.bfck(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bf != null) {
                try {
                    bf.close();
                }
                catch (IOException iOException) {}
            }
            if (raif != null) {
                try {
                    raif.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int writeMultiPageData(byte[] data, int page, int[] curPageOff, int[] nextPage) throws IOException {
        int len;
        int pageCounter = curPageOff[0];
        int curNextPage = nextPage[0];
        int curPage = page;
        for (int dct = 0; dct < data.length; dct += Math.min(len, data.length - dct)) {
            len = 1024 - pageCounter;
            if (len <= 0) {
                if (curNextPage == 0) {
                    curNextPage = this.allocPage();
                    BlockFile.pageSeek(this.file, curNextPage);
                    this.file.writeInt(1129270868);
                    this.file.writeInt(0);
                    BlockFile.pageSeek(this.file, curPage);
                    this.file.skipBytes(4);
                    this.file.writeInt(curNextPage);
                }
                BlockFile.pageSeek(this.file, curNextPage);
                curPage = curNextPage;
                int magic = this.file.readInt();
                if (magic != 1129270868) {
                    throw new IOException("Bad SkipSpan continuation magic number 0x" + Integer.toHexString(magic) + " on page " + curNextPage);
                }
                curNextPage = this.file.readUnsignedInt();
                pageCounter = 8;
                len = 1024 - pageCounter;
            }
            this.file.write(data, dct, Math.min(len, data.length - dct));
            pageCounter += Math.min(len, data.length - dct);
        }
        nextPage[0] = curNextPage;
        curPageOff[0] = pageCounter;
        return curPage;
    }

    public int readMultiPageData(byte[] arr, int page, int[] curPageOff, int[] nextPage) throws IOException {
        int res;
        int pageCounter = curPageOff[0];
        int curNextPage = nextPage[0];
        int curPage = page;
        for (int dct = 0; dct < arr.length; dct += res) {
            int len = 1024 - pageCounter;
            if (len <= 0) {
                if (curNextPage <= 0) {
                    throw new IOException("not enough pages to read data still need " + (arr.length - dct));
                }
                BlockFile.pageSeek(this.file, curNextPage);
                int magic = this.file.readInt();
                if (magic != 1129270868) {
                    throw new IOException("Bad SkipSpan continuation magic number 0x" + Integer.toHexString(magic) + " on page " + curNextPage);
                }
                curPage = curNextPage;
                curNextPage = this.file.readUnsignedInt();
                pageCounter = 8;
                len = 1024 - pageCounter;
            }
            if ((res = this.file.read(arr, dct, Math.min(len, arr.length - dct))) == -1) {
                throw new IOException();
            }
            pageCounter += Math.min(len, arr.length - dct);
        }
        nextPage[0] = curNextPage;
        curPageOff[0] = pageCounter;
        return curPage;
    }

    public int skipMultiPageBytes(int length, int page, int[] curPageOff, int[] nextPage) throws IOException {
        int res;
        int pageCounter = curPageOff[0];
        int curNextPage = nextPage[0];
        int curPage = page;
        for (int dct = 0; dct < length; dct += res) {
            int len = 1024 - pageCounter;
            if (len <= 0) {
                if (curNextPage <= 0) {
                    throw new IOException("not enough pages to skip");
                }
                BlockFile.pageSeek(this.file, curNextPage);
                int magic = this.file.readInt();
                if (magic != 1129270868) {
                    throw new IOException("Bad SkipSpan continuation magic number 0x" + Integer.toHexString(magic) + " on page " + curNextPage);
                }
                curPage = curNextPage;
                curNextPage = this.file.readUnsignedInt();
                pageCounter = 8;
                len = 1024 - pageCounter;
            }
            res = Math.min(len, length - dct);
            this.file.skipBytes(res);
            pageCounter += res;
        }
        nextPage[0] = curNextPage;
        curPageOff[0] = pageCounter;
        return curPage;
    }

    public BlockFile(RandomAccessInterface rai) throws IOException {
        this(rai, false);
    }

    public BlockFile(RandomAccessFile raf) throws IOException {
        this(new RAIFile(raf), false);
    }

    public BlockFile(RandomAccessFile raf, boolean init) throws IOException {
        this(new RAIFile(raf), init);
    }

    public BlockFile(File f, boolean init) throws IOException {
        this(new RAIFile(f, true, true), init);
    }

    public BlockFile(RandomAccessInterface rai, boolean init) throws IOException {
        if (rai == null) {
            throw new NullPointerException();
        }
        this.file = rai;
        if (init) {
            this.file.setLength(this.fileLen);
            this.writeSuperBlock();
            BSkipList.init(this, 2, this.spanSize);
        }
        this.readSuperBlock();
        if (this.magicBytes != 3549362387302744322L) {
            if ((this.magicBytes & 0x3141DE4932500000L) == 3549362387302744064L) {
                long major = this.magicBytes >> 8 & 0xFFL;
                long minor = this.magicBytes & 0xFFL;
                if (major < 1L || major == 1L && minor < 1L) {
                    throw new IOException("Expected 1.2 but got " + major + "." + minor);
                }
            } else {
                throw new IOException("Bad magic number");
            }
        }
        boolean bl = this._wasMounted = this.mounted != 0;
        if (this._wasMounted) {
            this.log.warn("Warning - file was not previously closed");
        }
        if (this.fileLen != this.file.length()) {
            throw new IOException("Expected file length " + this.fileLen + " but actually " + this.file.length());
        }
        if (rai.canWrite()) {
            this.mount();
        }
        this.metaIndex = new BSkipList<String, Integer>(this.spanSize, this, 2, new StringBytes(), new IntBytes());
    }

    public boolean wasMounted() {
        return this._wasMounted;
    }

    public static void pageSeek(RandomAccessInterface file, int page) throws IOException {
        if (page < 2) {
            throw new IOException("Negative page or superblock access attempt: " + page);
        }
        file.seek(((long)page - 1L) * 1024L);
    }

    public int allocPage() throws IOException {
        if (this.freeListStart != 0) {
            try {
                if (this.flb == null) {
                    this.flb = new FreeListBlock(this.file, this.freeListStart);
                }
                if (!this.flb.isEmpty()) {
                    if (this.log.shouldLog(10)) {
                        this.log.debug("Alloc from " + String.valueOf(this.flb));
                    }
                    return this.flb.takePage();
                }
                if (this.log.shouldLog(10)) {
                    this.log.debug("Alloc returning empty " + String.valueOf(this.flb));
                }
                this.freeListStart = this.flb.getNextPage();
                this.writeSuperBlock();
                int rv = this.flb.page;
                this.flb = null;
                return rv;
            }
            catch (IOException ioe) {
                this.log.error("Discarding corrupt free list block page " + this.freeListStart, ioe);
                this.freeListStart = 0;
            }
        }
        long offset = this.file.length();
        this.fileLen = offset + 1024L;
        this.file.setLength(this.fileLen);
        this.writeSuperBlock();
        return (int)(offset / 1024L + 1L);
    }

    public void freePage(int page) {
        if (page <= 2) {
            this.log.error("Bad page free attempt: " + page);
            return;
        }
        try {
            if (this.freeListStart == 0) {
                this.freeListStart = page;
                FreeListBlock.initPage(this.file, page);
                this.writeSuperBlock();
                if (this.log.shouldLog(10)) {
                    this.log.debug("Freed page " + page + " as new FLB");
                }
                return;
            }
            try {
                if (this.flb == null) {
                    this.flb = new FreeListBlock(this.file, this.freeListStart);
                }
                if (this.flb.isFull()) {
                    if (this.log.shouldLog(10)) {
                        this.log.debug("Full: " + String.valueOf(this.flb));
                    }
                    FreeListBlock.initPage(this.file, page);
                    if (this.flb.getNextPage() == 0) {
                        this.flb.setNextPage(page);
                    } else {
                        this.flb = new FreeListBlock(this.file, page);
                        this.flb.setNextPage(this.freeListStart);
                        this.freeListStart = page;
                        this.writeSuperBlock();
                    }
                    if (this.log.shouldLog(10)) {
                        this.log.debug("Freed page " + page + " to full " + String.valueOf(this.flb));
                    }
                    return;
                }
                this.flb.addPage(page);
                if (this.log.shouldLog(10)) {
                    this.log.debug("Freed page " + page + " to " + String.valueOf(this.flb));
                }
            }
            catch (IOException ioe) {
                this.log.error("Discarding corrupt free list block page " + this.freeListStart, ioe);
                this.freeListStart = page;
                FreeListBlock.initPage(this.file, page);
                this.writeSuperBlock();
                this.flb = null;
            }
        }
        catch (IOException ioe) {
            this.log.error("Error freeing page: " + page, ioe);
        }
    }

    public <K extends Comparable<? super K>, V> BSkipList<K, V> getIndex(String name, Serializer<K> key, Serializer<V> val) throws IOException {
        BSkipList<K, V> bsl = this.openIndices.get(name);
        if (bsl != null) {
            return bsl;
        }
        Integer page = (Integer)this.metaIndex.get(name);
        if (page == null) {
            return null;
        }
        bsl = new BSkipList<K, V>(this.spanSize, this, page, key, val, true);
        if (this.file.canWrite()) {
            this.log.info("Checking skiplist " + name + " in blockfile " + String.valueOf(this.file));
            if (bsl.bslck(true, false)) {
                this.log.logAlways(30, "Repaired skiplist " + name + " in blockfile " + String.valueOf(this.file));
            } else {
                this.log.info("No errors in skiplist " + name + " in blockfile " + String.valueOf(this.file));
            }
        }
        this.openIndices.put(name, bsl);
        return bsl;
    }

    public <K extends Comparable<? super K>, V> BSkipList<K, V> makeIndex(String name, Serializer<K> key, Serializer<V> val) throws IOException {
        if (this.metaIndex.get(name) != null) {
            throw new IOException("Index already exists");
        }
        int page = this.allocPage();
        this.metaIndex.put(name, page);
        BSkipList.init(this, page, this.spanSize);
        BSkipList<K, V> bsl = new BSkipList<K, V>(this.spanSize, this, page, key, val, true);
        this.openIndices.put(name, bsl);
        return bsl;
    }

    public void delIndex(String name) throws IOException {
        if (this.metaIndex.get(name) == null) {
            return;
        }
        BSkipList bsl = this.openIndices.get(name);
        if (bsl == null) {
            throw new IOException("Cannot delete closed skiplist, open it first: " + name);
        }
        bsl.delete();
        this.openIndices.remove(name);
        this.metaIndex.remove(name);
    }

    public void closeIndex(String name) {
        BSkipList bsl = this.openIndices.remove(name);
        if (bsl != null) {
            bsl.flush();
        }
    }

    public <K extends Comparable<? super K>, V> void reformatIndex(String name, Serializer<K> oldKey, Serializer<V> oldVal, Serializer<K> newKey, Serializer<V> newVal) throws IOException {
        if (this.openIndices.containsKey(name)) {
            throw new IOException("Cannot reformat open skiplist " + name);
        }
        BSkipList<Comparable, V> old = this.getIndex(name, oldKey, oldVal);
        if (old == null) {
            return;
        }
        long start = System.currentTimeMillis();
        String tmpName = "---tmp---" + name + "---tmp---";
        BSkipList tmp = this.getIndex(tmpName, newKey, newVal);
        if (tmp != null) {
            this.log.logAlways(30, "Continuing on aborted reformat of list " + name);
        } else {
            tmp = this.makeIndex(tmpName, newKey, newVal);
        }
        int loop = 32;
        ArrayList keys = new ArrayList(32);
        ArrayList vals = new ArrayList(32);
        while (true) {
            int i;
            Iterator iter = old.iterator();
            for (int i2 = 0; ((SkipIterator)iter).hasNext() && i2 < 32; ++i2) {
                try {
                    keys.add(((SkipIterator)iter).nextKey());
                    vals.add(((SkipIterator)iter).next());
                    continue;
                }
                catch (NoSuchElementException nsee) {
                    throw new IOException("Unable to reformat corrupt list " + name, nsee);
                }
            }
            boolean done = !((SkipIterator)iter).hasNext();
            for (i = 0; i < keys.size(); ++i) {
                tmp.put((Comparable)keys.get(i), vals.get(i));
            }
            for (i = keys.size() - 1; i >= 0; --i) {
                old.remove((Comparable)keys.get(i));
            }
            if (done) break;
            keys.clear();
            vals.clear();
        }
        this.delIndex(name);
        this.closeIndex(name);
        this.closeIndex(tmpName);
        Integer page = (Integer)this.metaIndex.get(tmpName);
        this.metaIndex.put(name, page);
        this.metaIndex.remove(tmpName);
        if (this.log.shouldWarn()) {
            this.log.warn("reformatted list: " + name + " in " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    @Override
    public void close() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        this.metaIndex.close();
        for (BSkipList bsl : this.openIndices.values()) {
            bsl.close();
        }
        if (this.file.canWrite()) {
            this.file.seek(20L);
            this.file.writeShort(0);
        }
    }

    public boolean bfck(boolean fix) {
        boolean rv;
        if (this.log.shouldLog(20)) {
            this.log.info("magic bytes " + this.magicBytes);
            this.log.info("fileLen " + this.fileLen);
            this.log.info("freeListStart " + this.freeListStart);
            this.log.info("mounted " + this.mounted);
            this.log.info("spanSize " + this.spanSize);
            this.log.info("Metaindex");
            this.log.info("Checking meta index in blockfile " + String.valueOf(this.file));
        }
        if (rv = this.metaIndex.bslck(fix, true)) {
            if (this.log.shouldLog(30)) {
                this.log.warn("Repaired meta index in blockfile " + String.valueOf(this.file));
            }
        } else if (this.log.shouldLog(20)) {
            this.log.info("No errors in meta index in blockfile " + String.valueOf(this.file));
        }
        int items = 0;
        Iterator iter = this.metaIndex.iterator();
        while (((SkipIterator)iter).hasNext()) {
            String slname = (String)((SkipIterator)iter).nextKey();
            Integer page = (Integer)((SkipIterator)iter).next();
            if (this.log.shouldLog(20)) {
                this.log.info("List " + slname + " page " + page);
            }
            try {
                boolean fail;
                if (slname.equals("%%__REVERSE__%%")) {
                    keyser = new IntBytes();
                    fail = this.getIndex(slname, keyser, new IdentityBytes()) == null;
                } else {
                    keyser = new UTF8StringBytes();
                    boolean bl = fail = this.getIndex(slname, keyser, new IdentityBytes()) == null;
                }
                if (fail) {
                    this.log.error("Can't find list? " + slname);
                    continue;
                }
                ++items;
            }
            catch (IOException ioe) {
                this.log.error("Error with list " + slname, ioe);
            }
        }
        this.log.info("Checked meta index and " + items + " skiplists");
        if (this.freeListStart != 0) {
            try {
                if (this.flb == null) {
                    this.flb = new FreeListBlock(this.file, this.freeListStart);
                }
                this.flb.flbck(true);
            }
            catch (IOException ioe) {
                this.log.error("Free list error", ioe);
            }
        } else if (this.log.shouldLog(20)) {
            this.log.info("No freelist");
        }
        return rv;
    }
}

