/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.SendMessageOptions;
import net.i2p.client.SendMessageStatusListener;
import net.i2p.client.streaming.I2PSocketException;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.client.streaming.impl.I2PSocketManagerFull;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class PacketQueue
implements SendMessageStatusListener,
Closeable {
    private final I2PAppContext _context;
    private final Log _log;
    private final ByteCache _cache = ByteCache.getInstance((int)64, (int)36864);
    private final Map<Long, Connection> _messageStatusMap;
    private volatile boolean _dead;
    private static final int FLAGS_INITIAL_TAGS = 1;
    private static final int FLAGS_FINAL_TAGS = 518;
    private static final int INITIAL_TAGS_TO_SEND = 32;
    private static final int MIN_TAG_THRESHOLD = 20;
    private static final int TAG_WINDOW_FACTOR = 5;
    private static final int FINAL_TAGS_TO_SEND = 4;
    private static final int FINAL_TAG_THRESHOLD = 2;
    private static final long REMOVE_EXPIRED_TIME = 67000L;
    private static final boolean ENABLE_STATUS_LISTEN = true;
    private static final long I2CP_EXPIRATION_ADJUST = Math.min(25, 25);

    public PacketQueue(I2PAppContext context, SimpleTimer2 timer) {
        this._context = context;
        this._log = context.logManager().getLog(PacketQueue.class);
        this._messageStatusMap = new ConcurrentHashMap<Long, Connection>(16);
        new RemoveExpired(timer);
    }

    @Override
    public void close() {
        this._dead = true;
        this._messageStatusMap.clear();
    }

    public boolean enqueue(PacketLocal packet) {
        boolean sent;
        ByteArray ba;
        Connection con;
        block45: {
            if (this._dead) {
                return false;
            }
            if (packet.getAckTime() > 0) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Not resending " + String.valueOf(packet));
                }
                return false;
            }
            con = packet.getConnection();
            if (con != null) {
                con.getInputStream().updateAcks(packet);
            }
            ba = (ByteArray)this._cache.acquire();
            byte[] buf = ba.getData();
            long begin = 0L;
            long end = 0L;
            sent = false;
            try {
                int size = 0;
                size = packet.shouldSign() ? packet.writeSignedPacket(buf, 0) : packet.writePacket(buf, 0);
                if (packet.getAckTime() > 0) {
                    return false;
                }
                begin = this._context.clock().now();
                long expires = 0L;
                int pktTimeout = packet.getTimeout();
                if (pktTimeout > 0) {
                    expires = Math.max(begin + (long)pktTimeout - I2CP_EXPIRATION_ADJUST, begin + 25L);
                }
                SendMessageOptions options = new SendMessageOptions();
                if (expires > 0L) {
                    options.setDate(expires);
                }
                boolean listenForStatus = false;
                if (packet.isFlagSet(518)) {
                    if (packet.isFlagSet(512)) {
                        if (packet.getSendStreamId() <= 0L) {
                            options.setSendLeaseSet(false);
                        }
                    } else {
                        options.setSendLeaseSet(false);
                    }
                    int sendTags = 4;
                    tagThresh = 2;
                    if (con != null) {
                        ConnectionOptions copts = con.getOptions();
                        int cSendTags = copts.getTagsToSend();
                        int cTagThresh = copts.getTagThreshold();
                        if (cSendTags < sendTags) {
                            sendTags = cSendTags;
                        }
                        if (cTagThresh < tagThresh) {
                            tagThresh = cTagThresh;
                        }
                    }
                    options.setTagsToSend(sendTags);
                    options.setTagThreshold(tagThresh);
                    options.setGzip(packet.getPayloadSize() > 50);
                } else if (packet.isFlagSet(1)) {
                    if (con != null) {
                        if (con.isInbound()) {
                            options.setSendLeaseSet(false);
                        } else {
                            listenForStatus = true;
                        }
                    }
                    int sendTags = 32;
                    tagThresh = 20;
                    if (con != null) {
                        ConnectionOptions copts = con.getOptions();
                        int cSendTags = copts.getTagsToSend();
                        int cTagThresh = copts.getTagThreshold();
                        if (cSendTags < sendTags) {
                            sendTags = cSendTags;
                        }
                        if (cTagThresh < tagThresh) {
                            tagThresh = cTagThresh;
                        }
                    }
                    options.setTagsToSend(sendTags);
                    options.setTagThreshold(tagThresh);
                    options.setGzip(packet.getPayloadSize() > 50);
                } else if (con != null) {
                    if (con.isInbound() && con.getLifetime() < 120000L) {
                        options.setSendLeaseSet(false);
                    }
                    ConnectionOptions copts = con.getOptions();
                    int wdw = copts.getWindowSize();
                    int thresh = Math.max(20, wdw * 5);
                    int cTagThresh = copts.getTagThreshold();
                    if (cTagThresh < thresh) {
                        thresh = cTagThresh;
                    }
                    options.setTagThreshold(thresh);
                }
                I2PSession session = packet.getSession();
                if (listenForStatus) {
                    long id = session.sendMessage(packet.getTo(), buf, 0, size, 6, packet.getLocalPort(), packet.getRemotePort(), options, (SendMessageStatusListener)this);
                    this._messageStatusMap.put(id, con);
                    sent = true;
                } else {
                    sent = session.sendMessage(packet.getTo(), buf, 0, size, 6, packet.getLocalPort(), packet.getRemotePort(), options);
                }
                end = this._context.clock().now();
                if (end - begin > 1000L && this._log.shouldLog(30)) {
                    this._log.warn("Took " + (end - begin) + "ms to sendMessage(...) " + String.valueOf(packet));
                }
                this._context.statManager().addRateData("stream.con.sendMessageSize", (long)size, packet.getLifetime());
                if (packet.getNumSends() > 1) {
                    this._context.statManager().addRateData("stream.con.sendDuplicateSize", (long)size, packet.getLifetime());
                }
                if (con != null) {
                    con.incrementBytesSent(size);
                    if (packet.getNumSends() > 1) {
                        con.incrementDupMessagesSent(1);
                    }
                }
            }
            catch (I2PSessionException ise) {
                if (!this._log.shouldLog(30)) break block45;
                this._log.warn("Unable to send the packet " + String.valueOf(packet), (Throwable)ise);
            }
        }
        this._cache.release(ba);
        if (!sent) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Send failed for " + String.valueOf(packet));
            }
            if (con != null) {
                con.disconnect(false);
            }
        } else {
            packet.incrementSends();
            if (con != null && this._log.shouldDebug()) {
                String suffix = "wsize " + con.getOptions().getWindowSize() + " rto " + con.getOptions().getRTO();
                con.getConnectionManager().getPacketHandler().displayPacket(packet, "SEND", suffix);
            }
            if (I2PSocketManagerFull.pcapWriter != null && this._context.getBooleanProperty("i2p.streaming.pcap")) {
                packet.logTCPDump();
            }
        }
        if (packet.getSequenceNum() == 0L && !packet.isFlagSet(1)) {
            packet.releasePayload();
        } else if (packet.isFlagSet(512) && !packet.isFlagSet(8)) {
            packet.releasePayload();
        } else if (packet.isFlagSet(4)) {
            packet.releasePayload();
        }
        return sent;
    }

    public void messageStatus(I2PSession session, long msgId, int status) {
        if (this._dead) {
            return;
        }
        Long id = msgId;
        Connection con = this._messageStatusMap.get(id);
        if (con == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Rcvd status " + status + " for msg " + msgId + " on unknown connection");
            }
            return;
        }
        switch (status) {
            case 3: 
            case 5: 
            case 7: 
            case 14: 
            case 16: {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rcvd soft failure status " + status + " for msg " + msgId + " on " + String.valueOf(con));
                }
                this._messageStatusMap.remove(id);
                break;
            }
            case 21: {
                if (this._log.shouldLog(30)) {
                    this._log.warn("LS lookup (soft) failure for msg " + msgId + " on " + String.valueOf(con));
                }
                this._messageStatusMap.remove(id);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 256: {
                if (con.getHighestAckedThrough() >= 0L) {
                    if (!this._log.shouldLog(30)) break;
                    this._log.warn("Rcvd hard failure but already connected, status " + status + " for msg " + msgId + " on " + String.valueOf(con));
                    break;
                }
                if (!con.getIsConnected()) {
                    if (!this._log.shouldLog(30)) break;
                    this._log.warn("Rcvd hard failure but already closed, status " + status + " for msg " + msgId + " on " + String.valueOf(con));
                    break;
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rcvd hard failure status " + status + " for msg " + msgId + " on " + String.valueOf(con));
                }
                this._messageStatusMap.remove(id);
                I2PSocketException ioe = new I2PSocketException(status);
                con.getOutputStream().streamErrorOccurred((IOException)ioe);
                con.getInputStream().streamErrorOccurred((IOException)ioe);
                con.setConnectionError(ioe.getLocalizedMessage());
                con.disconnect(false);
                break;
            }
            case 22: {
                this._messageStatusMap.remove(id);
                I2PSocketException ioe = new I2PSocketException(status);
                con.getOutputStream().streamErrorOccurred((IOException)ioe);
                con.getInputStream().streamErrorOccurred((IOException)ioe);
                con.setConnectionError(ioe.getLocalizedMessage());
                con.disconnect(false);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                if (this._log.shouldLog(20)) {
                    this._log.info("Rcvd success status " + status + " for msg " + msgId + " on " + String.valueOf(con));
                }
                this._messageStatusMap.remove(id);
                break;
            }
            case 1: {
                if (!this._log.shouldLog(20)) break;
                this._log.info("Rcvd accept status " + status + " for msg " + msgId + " on " + String.valueOf(con));
                break;
            }
            default: {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rcvd unknown status " + status + " for msg " + msgId + " on " + String.valueOf(con));
                }
                this._messageStatusMap.remove(id);
            }
        }
    }

    private class RemoveExpired
    extends SimpleTimer2.TimedEvent {
        public RemoveExpired(SimpleTimer2 timer) {
            super(timer, 67000L);
        }

        public void timeReached() {
            if (PacketQueue.this._dead) {
                return;
            }
            if (!PacketQueue.this._messageStatusMap.isEmpty()) {
                Iterator<Connection> iter = PacketQueue.this._messageStatusMap.values().iterator();
                while (iter.hasNext()) {
                    Connection con = iter.next();
                    if (con.getIsConnected() && con.getLifetime() <= 120000L) continue;
                    iter.remove();
                }
            }
            this.schedule(67000L);
        }
    }
}

