/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.util.Log;

class MessageInputStream
extends InputStream {
    private final Log _log;
    private final List<ByteArray> _readyDataBlocks;
    private int _readyDataBlockIndex;
    private long _highestReadyBlockId;
    private long _highestBlockId;
    private final Map<Long, ByteArray> _notYetReadyBlocks;
    private boolean _closeReceived;
    private boolean _locallyClosed;
    private int _readTimeout;
    private IOException _streamError;
    private long _readTotal;
    private final int _maxMessageSize;
    private final int _maxWindowSize;
    private final int _maxBufferSize;
    private final byte[] _oneByte = new byte[1];
    private final Object _dataLock;
    private static final ByteArray DUMMY_BA = new ByteArray(null);
    private static final int MIN_READY_BUFFERS = 16;

    public MessageInputStream(I2PAppContext ctx, int maxMessageSize, int maxWindowSize, int maxBufferSize) {
        this._log = ctx.logManager().getLog(MessageInputStream.class);
        this._readyDataBlocks = new ArrayList<ByteArray>(4);
        this._highestReadyBlockId = -1L;
        this._highestBlockId = -1L;
        this._readTimeout = -1;
        this._notYetReadyBlocks = new HashMap<Long, ByteArray>(4);
        this._dataLock = new Object();
        this._maxMessageSize = maxMessageSize;
        this._maxWindowSize = maxWindowSize;
        this._maxBufferSize = maxBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestReadyBlockId() {
        Object object = this._dataLock;
        synchronized (object) {
            return this._highestReadyBlockId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestBlockId() {
        Object object = this._dataLock;
        synchronized (object) {
            return this._highestBlockId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocallyClosed() {
        Object object = this._dataLock;
        synchronized (object) {
            return this._locallyClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAccept(long messageId, int payloadSize) {
        if (payloadSize <= 0) {
            return true;
        }
        Object object = this._dataLock;
        synchronized (object) {
            if (messageId <= this._highestReadyBlockId) {
                return true;
            }
            if (this._locallyClosed) {
                return this._notYetReadyBlocks.containsKey(messageId);
            }
            if (messageId < 16L) {
                return true;
            }
            if ((this._readyDataBlocks.size() + this._notYetReadyBlocks.size()) * this._maxMessageSize < this._maxBufferSize) {
                return true;
            }
            if (this._notYetReadyBlocks.containsKey(messageId)) {
                return true;
            }
            int available = this._maxBufferSize - this.getTotalReadySize();
            if (available <= 0) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Dropping message " + messageId + ", inbound buffer exceeded: available = " + available);
                }
                this._dataLock.notifyAll();
                return false;
            }
            int allowedBlocks = available / this._maxMessageSize;
            if (messageId > this._highestReadyBlockId + (long)allowedBlocks) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Dropping message " + messageId + ", inbound buffer exceeded: " + this._highestReadyBlockId + "/" + (this._highestReadyBlockId + (long)allowedBlocks) + "/" + available);
                }
                this._dataLock.notifyAll();
                return false;
            }
            if (this._readyDataBlocks.size() >= 4 * this._maxWindowSize) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Dropping message " + messageId + ", too many ready blocks");
                }
                this._dataLock.notifyAll();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getNacks() {
        Object object = this._dataLock;
        synchronized (object) {
            return this.locked_getNacks();
        }
    }

    private long[] locked_getNacks() {
        ArrayList<Long> ids = null;
        for (long i = this._highestReadyBlockId + 1L; i < this._highestBlockId; ++i) {
            Long l = i;
            if (this._notYetReadyBlocks.containsKey(l)) continue;
            if (ids == null) {
                ids = new ArrayList<Long>(4);
            }
            ids.add(l);
        }
        if (ids != null) {
            long[] rv = new long[ids.size()];
            for (int i = 0; i < rv.length; ++i) {
                rv[i] = (Long)ids.get(i);
            }
            return rv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAcks(PacketLocal packet) {
        if (packet.getSendStreamId() > 0L || !packet.isFlagSet(1)) {
            Object object = this._dataLock;
            synchronized (object) {
                packet.setAckThrough(this._highestBlockId);
                packet.setNacks(this.locked_getNacks());
            }
        } else {
            packet.setAckThrough(-1L);
        }
    }

    public int getReadTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(int timeout) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Changing read timeout from " + this._readTimeout + " to " + timeout + ": " + this.hashCode());
        }
        this._readTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReceived() {
        Object object = this._dataLock;
        synchronized (object) {
            if (this._log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Close received, ready bytes: ");
                long available = 0L;
                for (int i = 0; i < this._readyDataBlocks.size(); ++i) {
                    available += (long)this._readyDataBlocks.get(i).getValid();
                }
                buf.append(available -= (long)this._readyDataBlockIndex);
                buf.append(" blocks: ").append(this._readyDataBlocks.size());
                buf.append(" not ready blocks: [");
                long notAvailable = 0L;
                for (Map.Entry<Long, ByteArray> e : this._notYetReadyBlocks.entrySet()) {
                    Long id = e.getKey();
                    ByteArray ba = e.getValue();
                    buf.append(id).append(" ");
                    notAvailable += (long)ba.getValid();
                }
                buf.append("] not ready bytes: ").append(notAvailable);
                buf.append(" highest ready block: ").append(this._highestReadyBlockId);
                buf.append(" ID: ").append(this.hashCode());
                this._log.debug(buf.toString(), (Throwable)new Exception("Input stream closed"));
            }
            this._closeReceived = true;
            this._dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyActivity() {
        Object object = this._dataLock;
        synchronized (object) {
            this._dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean messageReceived(long messageId, ByteArray payload) {
        if (this._log.shouldLog(10)) {
            this._log.debug("received msg ID " + messageId + " with " + (String)(payload != null ? payload.getValid() + " bytes" : "no payload"));
        }
        Object object = this._dataLock;
        synchronized (object) {
            if (messageId <= this._highestReadyBlockId) {
                if (this._log.shouldLog(20)) {
                    this._log.info("ignoring dup message " + messageId);
                }
                return false;
            }
            if (messageId > this._highestBlockId) {
                this._highestBlockId = messageId;
            }
            if (this._highestReadyBlockId + 1L == messageId) {
                ByteArray ba;
                if (!this._locallyClosed && payload.getValid() > 0) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("accepting bytes as ready: " + payload.getValid());
                    }
                    this._readyDataBlocks.add(payload);
                }
                this._highestReadyBlockId = messageId;
                long cur = this._highestReadyBlockId + 1L;
                while ((ba = this._notYetReadyBlocks.remove(cur)) != null) {
                    if (ba.getData() != null && ba.getValid() > 0) {
                        this._readyDataBlocks.add(ba);
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("making ready the block " + cur);
                    }
                    ++cur;
                    ++this._highestReadyBlockId;
                }
                this._dataLock.notifyAll();
            } else if (this._locallyClosed) {
                if (this._log.shouldInfo()) {
                    this._log.info("Message received on closed stream: " + messageId);
                }
                this._notYetReadyBlocks.put(messageId, DUMMY_BA);
            } else {
                if (this._log.shouldInfo()) {
                    this._log.info("Message is out of order: " + messageId);
                }
                this._notYetReadyBlocks.put(messageId, payload);
            }
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this._oneByte, 0, 1);
        if (read <= 0) {
            return -1;
        }
        return this._oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] target) throws IOException {
        return this.read(target, 0, target.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] target, int offset, int length) throws IOException {
        int readTimeout = this._readTimeout;
        long expiration = readTimeout > 0 ? (long)readTimeout + System.currentTimeMillis() : -1L;
        boolean shouldDebug = this._log.shouldDebug();
        Object object = this._dataLock;
        synchronized (object) {
            if (this._locallyClosed) {
                throw new IOException("Input stream closed");
            }
            this.throwAnyError();
            int i = 0;
            while (i < length) {
                if (this._readyDataBlocks.isEmpty() && i == 0) {
                    while (this._readyDataBlocks.isEmpty()) {
                        if (this._locallyClosed) {
                            throw new IOException("Input stream closed");
                        }
                        if (this._notYetReadyBlocks.isEmpty() && this._closeReceived) {
                            if (this._log.shouldLog(20)) {
                                this._log.info("read(...," + offset + ", " + length + ")[" + i + "] got EOF after " + this._readTotal + ": " + this.hashCode());
                            }
                            return -1;
                        }
                        if (readTimeout < 0) {
                            if (shouldDebug) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + "] wait w/o timeout: " + this.hashCode());
                            }
                            try {
                                this._dataLock.wait();
                            }
                            catch (InterruptedException ie) {
                                InterruptedIOException ioe2 = new InterruptedIOException("Interrupted read");
                                ioe2.initCause(ie);
                                throw ioe2;
                            }
                            if (shouldDebug) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + "] wait w/o timeout complete: " + this.hashCode());
                            }
                            this.throwAnyError();
                        } else if (readTimeout > 0) {
                            if (shouldDebug) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + "] wait: " + readTimeout + ": " + this.hashCode());
                            }
                            try {
                                this._dataLock.wait(readTimeout);
                            }
                            catch (InterruptedException ie) {
                                InterruptedIOException ioe2 = new InterruptedIOException("Interrupted read");
                                ioe2.initCause(ie);
                                throw ioe2;
                            }
                            if (shouldDebug) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + "] wait complete: " + readTimeout + ": " + this.hashCode());
                            }
                            this.throwAnyError();
                        } else {
                            if (shouldDebug) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + "] nonblocking return: " + this.hashCode());
                            }
                            return 0;
                        }
                        if (!this._readyDataBlocks.isEmpty() || readTimeout <= 0) continue;
                        long remaining = expiration - System.currentTimeMillis();
                        if (remaining <= 0L) {
                            if (this._log.shouldLog(20)) {
                                this._log.info("read(...," + offset + ", " + length + ")[" + i + "] timed out: " + this.hashCode());
                            }
                            throw new SocketTimeoutException();
                        }
                        readTimeout = (int)remaining;
                    }
                    continue;
                }
                if (this._readyDataBlocks.isEmpty()) {
                    if (shouldDebug) {
                        this._log.debug("read(...," + offset + ", " + length + ")[" + i + "] no more ready blocks, returning: " + this.hashCode());
                    }
                    return i;
                }
                ByteArray cur = this._readyDataBlocks.get(0);
                int toRead = Math.min(cur.getValid() - this._readyDataBlockIndex, length - i);
                System.arraycopy(cur.getData(), cur.getOffset() + this._readyDataBlockIndex, target, offset + i, toRead);
                this._readyDataBlockIndex += toRead;
                if (cur.getValid() <= this._readyDataBlockIndex) {
                    this._readyDataBlockIndex = 0;
                    this._readyDataBlocks.remove(0);
                }
                this._readTotal += (long)toRead;
                if (shouldDebug) {
                    this._log.debug("read(...," + offset + ", " + length + ")[" + i + "] copied " + toRead + " after ready data: readyDataBlockIndex=" + this._readyDataBlockIndex + " readyBlocks=" + this._readyDataBlocks.size() + " readTotal=" + this._readTotal + ": " + this.hashCode());
                }
                i += toRead;
            }
        }
        if (shouldDebug) {
            this._log.debug("read(byte[]," + offset + "," + length + ") read fully; total read: " + this._readTotal);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        int numBytes = 0;
        Object object = this._dataLock;
        synchronized (object) {
            if (this._locallyClosed) {
                throw new IOException("Input stream closed");
            }
            this.throwAnyError();
            for (int i = 0; i < this._readyDataBlocks.size(); ++i) {
                ByteArray cur = this._readyDataBlocks.get(i);
                if (i == 0) {
                    numBytes += cur.getValid() - this._readyDataBlockIndex;
                    continue;
                }
                numBytes += cur.getValid();
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("available(): " + numBytes + ": " + this.hashCode());
        }
        return numBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalReadySize() {
        Object object = this._dataLock;
        synchronized (object) {
            if (this._locallyClosed) {
                return 0;
            }
            int numBytes = 0;
            for (int i = 0; i < this._readyDataBlocks.size(); ++i) {
                ByteArray cur = this._readyDataBlocks.get(i);
                numBytes += cur.getValid();
                if (i != 0) continue;
                numBytes -= this._readyDataBlockIndex;
            }
            return numBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._dataLock;
        synchronized (object) {
            if (this._log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("close(), ready bytes: ");
                long available = 0L;
                for (int i = 0; i < this._readyDataBlocks.size(); ++i) {
                    available += (long)this._readyDataBlocks.get(i).getValid();
                }
                buf.append(available -= (long)this._readyDataBlockIndex);
                buf.append(" blocks: ").append(this._readyDataBlocks.size());
                buf.append(" not ready blocks: [");
                long notAvailable = 0L;
                for (Map.Entry<Long, ByteArray> e : this._notYetReadyBlocks.entrySet()) {
                    Long id = e.getKey();
                    ByteArray ba = e.getValue();
                    buf.append(id).append(" ");
                    notAvailable += (long)ba.getValid();
                }
                buf.append("] not ready bytes: ").append(notAvailable);
                buf.append(" highest ready block: ").append(this._highestReadyBlockId);
                buf.append(" ID: ").append(this.hashCode());
                this._log.debug(buf.toString());
            }
            this._readyDataBlocks.clear();
            for (ByteArray ba : this._notYetReadyBlocks.values()) {
                ba.setData(null);
            }
            this._locallyClosed = true;
            this._dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamErrorOccurred(IOException ioe) {
        Object object = this._dataLock;
        synchronized (object) {
            if (this._streamError == null) {
                this._streamError = ioe;
            }
            this._locallyClosed = true;
            this._dataLock.notifyAll();
        }
    }

    private void throwAnyError() throws IOException {
        IOException ioe = this._streamError;
        if (ioe != null) {
            this._streamError = null;
            IOException ioe2 = new IOException("Input stream error");
            ioe2.initCause(ioe);
            throw ioe2;
        }
    }
}

