/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.util.PasswordManager;

public class RouterPasswordManager
extends PasswordManager {
    protected final RouterContext _context;
    private static final String PROP_MIGRATED = "router.passwordManager.migrated";
    private static final String PROP_I2CP_OLD_PW = "i2cp.password";
    private static final String PROP_I2CP_OLD_USER = "i2cp.username";
    private static final String PROP_I2CP_NEW = "i2cp.auth";

    public RouterPasswordManager(RouterContext ctx) {
        super(ctx);
        this._context = ctx;
        this.migrate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean migrate() {
        Class<RouterPasswordManager> clazz = RouterPasswordManager.class;
        synchronized (RouterPasswordManager.class) {
            if (this._context.getBooleanProperty(PROP_MIGRATED)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            String user = this._context.getProperty(PROP_I2CP_OLD_USER);
            String pw = this._context.getProperty(PROP_I2CP_OLD_PW);
            if (pw != null && user != null && pw.length() > 0 && user.length() > 0) {
                this.saveHash(PROP_I2CP_NEW, user, pw);
            }
            HashMap<String, String> toAdd = new HashMap<String, String>(5);
            ArrayList<String> toDel = new ArrayList<String>(5);
            toDel.add(PROP_I2CP_OLD_USER);
            toDel.add(PROP_I2CP_OLD_PW);
            toAdd.put(PROP_MIGRATED, "true");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._context.router().saveConfig(toAdd, toDel);
        }
    }

    public boolean save(String realm, String user, String pw) {
        return this.saveHash(realm, user, pw);
    }

    public boolean savePlain(String realm, String user, String pw) {
        Object pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = (String)pfx + "." + user;
        }
        Map<CallSite, String> toAdd = Collections.singletonMap((String)pfx + ".password", pw);
        ArrayList<String> toDel = new ArrayList<String>(4);
        toDel.add((String)pfx + ".b64");
        toDel.add((String)pfx + ".md5");
        toDel.add((String)pfx + ".crypt");
        toDel.add((String)pfx + ".shash");
        return this._context.router().saveConfig(toAdd, toDel);
    }

    public boolean saveB64(String realm, String user, String pw) {
        Object pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = (String)pfx + "." + user;
        }
        String b64 = Base64.encode(DataHelper.getUTF8(pw));
        Map<CallSite, String> toAdd = Collections.singletonMap((String)pfx + ".b64", b64);
        ArrayList<String> toDel = new ArrayList<String>(4);
        toDel.add((String)pfx + ".password");
        toDel.add((String)pfx + ".md5");
        toDel.add((String)pfx + ".crypt");
        toDel.add((String)pfx + ".shash");
        return this._context.router().saveConfig(toAdd, toDel);
    }

    public boolean saveHash(String realm, String user, String pw) {
        Object pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = (String)pfx + "." + user;
        }
        String shash = this.createHash(pw);
        Map<CallSite, String> toAdd = Collections.singletonMap((String)pfx + ".shash", shash);
        ArrayList<String> toDel = new ArrayList<String>(4);
        toDel.add((String)pfx + ".password");
        toDel.add((String)pfx + ".b64");
        toDel.add((String)pfx + ".md5");
        toDel.add((String)pfx + ".crypt");
        return this._context.router().saveConfig(toAdd, toDel);
    }

    public boolean remove(String realm, String user) {
        Object pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = (String)pfx + "." + user;
        }
        ArrayList<String> toDel = new ArrayList<String>(5);
        toDel.add((String)pfx + ".password");
        toDel.add((String)pfx + ".b64");
        toDel.add((String)pfx + ".md5");
        toDel.add((String)pfx + ".crypt");
        toDel.add((String)pfx + ".shash");
        return this._context.router().saveConfig(null, toDel);
    }
}

