/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.util.Log;

class FloodfillRouterInfoFloodJob
extends JobImpl {
    private final Log _log;
    private final FloodfillNetworkDatabaseFacade _facade;
    private static final int FLOOD_PEERS = 6;

    public FloodfillRouterInfoFloodJob(RouterContext context, FloodfillNetworkDatabaseFacade facade) {
        super(context);
        this._facade = facade;
        this._log = context.logManager().getLog(FloodfillRouterInfoFloodJob.class);
    }

    @Override
    public String getName() {
        return "Flood our RouterInfo to nearby floodfills";
    }

    @Override
    public void runJob() {
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this._facade.getPeerSelector();
        List<Hash> peers = sel.selectFloodfillParticipants(this.getContext().routerHash(), 6, null);
        for (Hash ri : peers) {
            DatabaseStoreMessage dsm = new DatabaseStoreMessage(this.getContext());
            dsm.setMessageExpiration(this.getContext().clock().now() + 10000L);
            dsm.setEntry(this.getContext().router().getRouterInfo());
            RouterInfo nextPeerInfo = this.getContext().netDb().lookupRouterInfoLocally(ri);
            if (nextPeerInfo == null) continue;
            OutNetMessage outMsg = new OutNetMessage(this.getContext(), dsm, this.getContext().clock().now() + 10000L, 460, nextPeerInfo);
            this.getContext().outNetMessagePool().add(outMsg);
            if (!this._log.shouldLog(10)) continue;
            this._log.logAlways(10, "Sending our RI to: " + String.valueOf(nextPeerInfo.getHash()));
        }
    }
}

