/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.router.RouterKeyGenerator;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class ExpireLeasesJob
extends JobImpl {
    private final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 60000L;
    private static final int LIMIT_LEASES_FF = 1250;
    private static final int LIMIT_LEASES_CLIENT = SystemVersion.isSlow() ? 300 : 750;

    public ExpireLeasesJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(ExpireLeasesJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Expire Lease Sets Job";
    }

    @Override
    public void runJob() {
        List<Hash> toExpire = this.selectKeysToExpire();
        if (!toExpire.isEmpty()) {
            for (Hash key : toExpire) {
                this._facade.fail(key);
            }
            if (this._log.shouldInfo()) {
                this._log.info(String.valueOf(this._facade) + " Leases expired: " + toExpire.size());
            }
        }
        this.requeue(60000L);
    }

    private List<Hash> selectKeysToExpire() {
        int limit;
        RouterContext ctx = this.getContext();
        boolean isClient = this._facade.isClientDb();
        boolean isFFDB = this._facade.floodfillEnabled() && !isClient;
        Set<Map.Entry<Hash, DatabaseEntry>> entries = this._facade.getDataStore().getMapEntries();
        ArrayList<LeaseSet> current = new ArrayList<LeaseSet>(isFFDB ? 512 : (isClient ? entries.size() : 128));
        ArrayList<Hash> toExpire = new ArrayList<Hash>(Math.min(entries.size(), 128));
        int sz = 0;
        for (Map.Entry<Hash, DatabaseEntry> entry : entries) {
            DatabaseEntry obj = entry.getValue();
            if (!obj.isLeaseSet()) continue;
            LeaseSet ls = (LeaseSet)obj;
            Hash h = entry.getKey();
            boolean isLocal = ctx.clientManager().isLocal(h);
            if (!ls.isCurrent(60000L)) {
                toExpire.add(h);
                if (!isLocal) continue;
                this._log.logAlways(30, "Expired local leaseset " + h.toBase32());
                continue;
            }
            if (isLocal) continue;
            ++sz;
            if (ls.getReceivedAsReply()) continue;
            current.add(ls);
        }
        int origsz = sz;
        int n = limit = isFFDB ? 1250 : LIMIT_LEASES_CLIENT;
        if (sz > limit) {
            int exp;
            if (isFFDB) {
                RouterKeyGenerator gen = ctx.routerKeyGenerator();
                byte[] ourRKey = ctx.routerHash().getData();
                for (LeaseSet ls : current) {
                    Hash h = ls.getHash();
                    byte[] rkey = gen.getRoutingKey(h).getData();
                    int distance = ((rkey[0] ^ ourRKey[0]) & 0xFF) << 8 | (rkey[1] ^ ourRKey[1]) & 0xFF;
                    if (distance < 256) continue;
                    toExpire.add(h);
                    if (--sz > limit) continue;
                    break;
                }
            } else {
                Collections.sort(current, new LeaseSetComparator());
                for (LeaseSet ls : current) {
                    toExpire.add(ls.getHash());
                    if (--sz > limit) continue;
                    break;
                }
            }
            if ((exp = origsz - sz) > 0 && this._log.shouldWarn()) {
                this._log.warn("Aggressive LS expire for " + String.valueOf(this._facade) + " removed " + exp + " leasesets, limit " + limit + ", size now " + sz);
            }
        }
        return toExpire;
    }

    private static class LeaseSetComparator
    implements Comparator<LeaseSet> {
        private LeaseSetComparator() {
        }

        @Override
        public int compare(LeaseSet l, LeaseSet r) {
            long dr;
            long dl = l.getLatestLeaseDate();
            if (dl < (dr = r.getLatestLeaseDate())) {
                return -1;
            }
            if (dl > dr) {
                return 1;
            }
            return 0;
        }
    }
}

