/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.BlindData;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.Payload;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.i2cp.BandwidthLimitsMessage;
import net.i2p.data.i2cp.BlindingInfoMessage;
import net.i2p.data.i2cp.CreateLeaseSet2Message;
import net.i2p.data.i2cp.CreateLeaseSetMessage;
import net.i2p.data.i2cp.CreateSessionMessage;
import net.i2p.data.i2cp.DestLookupMessage;
import net.i2p.data.i2cp.DestroySessionMessage;
import net.i2p.data.i2cp.GetBandwidthLimitsMessage;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.HostLookupMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.data.i2cp.ReceiveMessageBeginMessage;
import net.i2p.data.i2cp.ReceiveMessageEndMessage;
import net.i2p.data.i2cp.ReconfigureSessionMessage;
import net.i2p.data.i2cp.SendMessageExpiresMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.data.i2cp.SessionStatusMessage;
import net.i2p.data.i2cp.SetDateMessage;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.CreateSessionJob;
import net.i2p.router.client.LookupDestJob;
import net.i2p.util.Log;
import net.i2p.util.PasswordManager;

class ClientMessageEventListener
implements I2CPMessageReader.I2CPMessageEventListener {
    private final Log _log;
    protected final RouterContext _context;
    protected final ClientConnectionRunner _runner;
    private final boolean _enforceAuth;
    private volatile boolean _authorized;
    private static final String PROP_AUTH = "i2cp.auth";
    private static final String PROP_AUTH_STRICT = "i2cp.strictAuth";

    public ClientMessageEventListener(RouterContext context, ClientConnectionRunner runner, boolean enforceAuth) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientMessageEventListener.class);
        this._runner = runner;
        this._enforceAuth = enforceAuth;
        if (!this._enforceAuth || !this._context.getBooleanProperty(PROP_AUTH)) {
            this._authorized = true;
        }
        this._context.statManager().createRateStat("client.distributeTime", "How long it took to inject the client message into the router", "ClientMessages", new long[]{60000L, 600000L, 3600000L});
    }

    @Override
    public void messageReceived(I2CPMessageReader reader, I2CPMessage message) {
        boolean strict;
        if (this._runner.isDead()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Received but runner dead: \n" + String.valueOf(message));
            }
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Message received: \n" + String.valueOf(message));
        }
        int type = message.getType();
        if (!this._authorized && ((strict = this._context.getBooleanPropertyDefaultTrue(PROP_AUTH_STRICT)) && type != 32 || type != 1 && type != 32 && type != 34 && type != 8)) {
            this._log.error("Received message type " + type + " without required authentication");
            this._runner.disconnectClient("Authorization required");
            return;
        }
        switch (message.getType()) {
            case 32: {
                this.handleGetDate((GetDateMessage)message);
                break;
            }
            case 33: {
                this.handleSetDate((SetDateMessage)message);
                break;
            }
            case 1: {
                this.handleCreateSession((CreateSessionMessage)message);
                break;
            }
            case 5: {
                this.handleSendMessage((SendMessageMessage)message);
                break;
            }
            case 36: {
                this.handleSendMessage((SendMessageExpiresMessage)message);
                break;
            }
            case 6: {
                this.handleReceiveBegin((ReceiveMessageBeginMessage)message);
                break;
            }
            case 7: {
                this.handleReceiveEnd((ReceiveMessageEndMessage)message);
                break;
            }
            case 4: 
            case 41: {
                this.handleCreateLeaseSet((CreateLeaseSetMessage)message);
                break;
            }
            case 3: {
                this.handleDestroySession((DestroySessionMessage)message);
                break;
            }
            case 34: {
                this.handleDestLookup((DestLookupMessage)message);
                break;
            }
            case 38: {
                this.handleHostLookup((HostLookupMessage)message);
                break;
            }
            case 2: {
                this.handleReconfigureSession((ReconfigureSessionMessage)message);
                break;
            }
            case 8: {
                this.handleGetBWLimits((GetBandwidthLimitsMessage)message);
                break;
            }
            case 42: {
                this.handleBlindingInfo((BlindingInfoMessage)message);
                break;
            }
            default: {
                if (!this._log.shouldLog(40)) break;
                this._log.error("Unhandled I2CP type received: " + message.getType());
            }
        }
    }

    @Override
    public void readError(I2CPMessageReader reader, Exception error) {
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Error occurred", error);
        }
        this._runner.disconnectClient(error.toString());
        this._runner.stopRunning();
    }

    @Override
    public void disconnected(I2CPMessageReader reader) {
        if (this._runner.isDead()) {
            return;
        }
        this._runner.disconnected();
    }

    private void handleGetDate(GetDateMessage message) {
        block4: {
            Properties props;
            String clientVersion = message.getVersion();
            if (clientVersion != null) {
                this._runner.setClientVersion(clientVersion);
            }
            if (!this.checkAuth(props = message.getOptions())) {
                return;
            }
            try {
                this._runner.doSend(new SetDateMessage(clientVersion != null ? "0.9.67" : null));
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(40)) break block4;
                this._log.error("Error writing out the setDate message", ime);
            }
        }
    }

    private void handleSetDate(SetDateMessage message) {
    }

    private void handleCreateSession(CreateSessionMessage message) {
        String name2;
        String lsType;
        SessionConfig in = message.getSessionConfig();
        Destination dest = in.getDestination();
        if (dest.getEncType() != EncType.ELGAMAL_2048) {
            this._runner.disconnectClient("Non-ElGamal encryption type in key certificate unsupported");
            return;
        }
        if (in.verifySignature()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Signature verified correctly on create session message");
            }
        } else {
            int itype = dest.getCertificate().getCertificateType();
            SigType stype = SigType.getByCode(itype);
            if (stype == null || !stype.isAvailable()) {
                this._log.error("Client requested unsupported signature type " + itype);
                this._runner.disconnectClient("Unsupported signature type " + itype);
            } else if (in.tooOld()) {
                long skew = this._context.clock().now() - in.getCreationDate().getTime();
                Object msg = "Create session message client clock skew? ";
                msg = skew >= 0L ? (String)msg + DataHelper.formatDuration(skew) + " in the past" : (String)msg + DataHelper.formatDuration(0L - skew) + " in the future";
                this._log.error((String)msg);
                this._runner.disconnectClient((String)msg);
            } else if (in.getOfflineSignature() != null && in.getOfflineExpiration() < this._context.clock().now()) {
                String msg = "Offline signature for tunnel expired " + DataHelper.formatTime(in.getOfflineExpiration());
                this._log.log(50, msg);
                this._runner.disconnectClient(msg);
            } else {
                this._log.error("Signature verification failed on a create session message:\n" + String.valueOf(in));
                this._runner.disconnectClient("Invalid signature on CreateSessionMessage");
            }
            return;
        }
        Properties inProps = in.getOptions();
        if (!this.checkAuth(inProps)) {
            return;
        }
        SessionId id = this._runner.getSessionId(dest.calculateHash());
        if (id != null) {
            this._runner.disconnectClient("Already have session " + String.valueOf(id));
            return;
        }
        SessionConfig cfg = new SessionConfig(dest);
        cfg.setSignature(in.getSignature());
        Properties props = new Properties();
        boolean isPrimary = this._runner.getSessionIds().isEmpty();
        if (!isPrimary) {
            SessionConfig pcfg = this._runner.getPrimaryConfig();
            if (pcfg != null) {
                props.putAll((Map<?, ?>)pcfg.getOptions());
            } else {
                this._log.error("no primary config?");
            }
        }
        props.putAll((Map<?, ?>)inProps);
        String senc = props.getProperty("i2cp.leaseSetEncType");
        if (senc != null) {
            String[] senca;
            for (String sencaa : senca = DataHelper.split(senc, ",")) {
                EncType type = EncType.parseEncType(sencaa);
                if (type != null) {
                    if (type.isAvailable()) continue;
                    String msg = "Unsupported crypto type: " + String.valueOf((Object)type);
                    this._log.error(msg);
                    this._runner.disconnectClient(msg);
                    return;
                }
                String msg = "Unsupported crypto type: " + sencaa;
                this._log.error(msg);
                this._runner.disconnectClient(msg);
                return;
            }
        }
        if ("5".equals(lsType = props.getProperty("i2cp.leaseSetType"))) {
            SigType stype = dest.getSigningPublicKey().getType();
            if (stype != SigType.EdDSA_SHA512_Ed25519 && stype != SigType.RedDSA_SHA512_Ed25519) {
                this._runner.disconnectClient("Invalid sig type for encrypted LS");
                return;
            }
        } else if ("7".equals(lsType)) {
            props.setProperty("inbound.length", "0");
            props.setProperty("outbound.length", "0");
            props.setProperty("inbound.lengthVariance", "0");
            props.setProperty("outbound.lengthVariance", "0");
        } else if (lsType == null && props.getProperty("i2cp.leaseSetOfflineSignature") != null) {
            props.setProperty("i2cp.leaseSetType", "3");
        }
        String name = props.getProperty("inbound.nickname");
        if (name == null || name.trim().isEmpty()) {
            name = dest.toBase32();
            props.setProperty("inbound.nickname", name);
        }
        if ((name2 = props.getProperty("outbound.nickname")) == null || name2.trim().isEmpty()) {
            props.setProperty("outbound.nickname", name);
        }
        cfg.setOptions(props);
        int status = this._runner.sessionEstablished(cfg);
        if (status != 1) {
            if (this._log.shouldLog(40)) {
                this._log.error("Session establish failed: code = " + status);
            }
            String msg = status == 5 ? "duplicate destination" : (status == 3 ? "bad session configuration parameters" : (status == 4 ? "session limit exceeded" : "unknown error"));
            this._runner.disconnectClient(msg);
            return;
        }
        id = this._runner.getSessionId(dest.calculateHash());
        if (this._log.shouldLog(20)) {
            this._log.info("Session " + String.valueOf(id) + " established for " + String.valueOf(dest.calculateHash()));
        }
        if (isPrimary) {
            this.sendStatusMessage(id, status);
            this.startCreateSessionJob(cfg);
        } else {
            SessionConfig pcfg = this._runner.getPrimaryConfig();
            if (pcfg != null) {
                ClientTunnelSettings settings = new ClientTunnelSettings(dest.calculateHash());
                settings.readFromProperties(props);
                this.sendStatusMessage(id, status);
                boolean ok = this._context.tunnelManager().addAlias(dest, settings, pcfg.getDestination());
                if (!ok) {
                    this._log.error("Add alias failed");
                }
            } else {
                this._log.error("no primary config?");
                status = 3;
                this.sendStatusMessage(id, status);
            }
        }
    }

    private boolean checkAuth(Properties props) {
        if (this._authorized) {
            return true;
        }
        if (this._enforceAuth && this._context.getBooleanProperty(PROP_AUTH)) {
            String user = null;
            String pw = null;
            if (props != null) {
                user = props.getProperty("i2cp.username");
                pw = props.getProperty("i2cp.password");
            }
            if (user == null || user.length() == 0 || pw == null || pw.length() == 0) {
                this._log.logAlways(30, "I2CP authentication failed");
                this._runner.disconnectClient("Authorization required, specify i2cp.username and i2cp.password in options");
                this._authorized = false;
                return false;
            }
            PasswordManager mgr = new PasswordManager(this._context);
            if (!mgr.checkHash(PROP_AUTH, user, pw)) {
                String msg = "I2CP authentication failed, user: " + user + " IP: " + String.valueOf(this._runner.getAddress());
                this._log.logAlways(30, msg);
                this._runner.disconnectClient(msg);
                this._authorized = false;
                return false;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("I2CP auth success user: " + user);
            }
        }
        this._authorized = true;
        return true;
    }

    protected void startCreateSessionJob(SessionConfig config) {
        this._context.jobQueue().addJob(new CreateSessionJob(this._context, config));
    }

    private void handleSendMessage(SendMessageMessage message) {
        MessageId id;
        SessionId sid = message.getSessionId();
        SessionConfig cfg = this._runner.getConfig(sid);
        if (cfg == null) {
            block11: {
                List<SessionId> current = this._runner.getSessionIds();
                String msg = "SendMessage invalid session: " + String.valueOf(sid) + " current: " + String.valueOf(current);
                if (this._log.shouldLog(40)) {
                    this._log.error(msg);
                }
                if (sid != null && message.getNonce() > 0L) {
                    MessageStatusMessage status = new MessageStatusMessage();
                    status.setMessageId(this._runner.getNextMessageId());
                    status.setSessionId(sid.getSessionId());
                    status.setSize(0L);
                    status.setNonce(message.getNonce());
                    status.setStatus(10);
                    try {
                        this._runner.doSend(status);
                    }
                    catch (I2CPMessageException ime) {
                        if (!this._log.shouldLog(30)) break block11;
                        this._log.warn("Error writing out the message status message", ime);
                    }
                }
            }
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("handleSendMessage called");
        }
        long beforeDistribute = this._context.clock().now();
        try {
            id = this._runner.distributeMessage(message);
        }
        catch (Exception e) {
            block12: {
                this._log.error("Error sending message", e);
                MessageStatusMessage status = new MessageStatusMessage();
                status.setMessageId(this._runner.getNextMessageId());
                status.setSessionId(sid.getSessionId());
                status.setSize(0L);
                status.setNonce(message.getNonce());
                status.setStatus(8);
                try {
                    this._runner.doSend(status);
                }
                catch (I2CPMessageException ime) {
                    if (!this._log.shouldLog(30)) break block12;
                    this._log.warn("Error writing out the message status message", ime);
                }
            }
            return;
        }
        long timeToDistribute = this._context.clock().now() - beforeDistribute;
        this._runner.ackSendMessage(sid, id, message.getNonce());
        this._context.statManager().addRateData("client.distributeTime", timeToDistribute);
        if (timeToDistribute > 50L && this._log.shouldLog(10)) {
            this._log.debug("Took too long to distribute the message (which holds up the ack): " + timeToDistribute);
        }
    }

    private void handleReceiveBegin(ReceiveMessageBeginMessage message) {
        Payload payload;
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Handling receive begin: id = " + message.getMessageId());
        }
        if ((payload = this._runner.getPayload(new MessageId(message.getMessageId()))) == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Payload for message id [" + message.getMessageId() + "] is null!  Dropped or Unknown message id");
            }
            return;
        }
        MessagePayloadMessage msg = new MessagePayloadMessage(message.getSessionId(), message.getMessageId(), payload);
        try {
            this._runner.doSend(msg);
        }
        catch (I2CPMessageException ime) {
            String emsg = "Error sending data to client " + String.valueOf(this._runner.getDestHash());
            if (this._log.shouldWarn()) {
                this._log.warn(emsg, ime);
            } else {
                this._log.logAlways(30, emsg);
            }
            this._runner.removePayload(new MessageId(message.getMessageId()));
        }
    }

    private void handleReceiveEnd(ReceiveMessageEndMessage message) {
        this._runner.removePayload(new MessageId(message.getMessageId()));
    }

    private void handleDestroySession(DestroySessionMessage message) {
        SessionId id = message.getSessionId();
        if (id != null) {
            this._runner.removeSession(id);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("destroy session with null ID");
        }
        int left = this._runner.getSessionIds().size();
        if (left <= 0 || id == null) {
            this._runner.stopRunning();
        } else if (this._log.shouldLog(20)) {
            this._log.info("Still " + left + " sessions left");
        }
    }

    protected void handleCreateLeaseSet(CreateLeaseSetMessage message) {
        Object pk;
        LeaseSet ls = message.getLeaseSet();
        if (ls == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Null lease set granted: " + String.valueOf(message));
            }
            this._runner.disconnectClient("Invalid CreateLeaseSetMessage - null LS");
            return;
        }
        int type = ls.getType();
        if (type != 7 && type != 5 && message.getPrivateKey() == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Null private keys: " + String.valueOf(message));
            }
            this._runner.disconnectClient("Invalid CreateLeaseSetMessage - null private keys");
            return;
        }
        if (type == 1 && message.getSigningPrivateKey() == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Null private keys: " + String.valueOf(message));
            }
            this._runner.disconnectClient("Invalid CreateLeaseSetMessage - null private keys");
            return;
        }
        SessionId id = message.getSessionId();
        SessionConfig cfg = this._runner.getConfig(id);
        if (cfg == null) {
            List<SessionId> current = this._runner.getSessionIds();
            String msg = "CreateLeaseSet invalid session: " + String.valueOf(id) + " current: " + String.valueOf(current);
            if (this._log.shouldLog(40)) {
                this._log.error(msg);
            }
            this._runner.disconnectClient(msg);
            return;
        }
        Destination dest = cfg.getDestination();
        if (type == 5) {
            String secret = cfg.getOptions().getProperty("i2cp.leaseSetSecret");
            if (secret != null) {
                EncryptedLeaseSet encls = (EncryptedLeaseSet)ls;
                secret = DataHelper.getUTF8(Base64.decode(secret));
                encls.setSecret(secret);
            }
            try {
                ls.setDestination(dest);
            }
            catch (RuntimeException re) {
                if (this._log.shouldError()) {
                    this._log.error("Error decrypting leaseset from client", re);
                }
                this._runner.disconnectClient(re.toString());
                return;
            }
            pk = cfg.getOptions().getProperty("i2cp.leaseSetPrivKey");
            if (pk != null) {
                byte[] priv = Base64.decode((String)pk);
                PrivateKey privkey = new PrivateKey(EncType.ECIES_X25519, priv);
                EncryptedLeaseSet encls = (EncryptedLeaseSet)ls;
                encls.setClientPrivateKey(privkey);
            }
            if (!ls.verifySignature()) {
                if (this._log.shouldError()) {
                    this._log.error("Error decrypting leaseset from client");
                }
                this._runner.disconnectClient("Error decrypting leaseset from client");
                return;
            }
        } else {
            Destination ndest = ls.getDestination();
            if (!dest.equals(ndest)) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Different destination in LS");
                }
                this._runner.disconnectClient("Different destination in LS");
                return;
            }
        }
        if (type != 7) {
            LeaseSetKeys keys = this._context.keyManager().getKeys(dest);
            if (keys == null || !message.getPrivateKey().equals(keys.getDecryptionKey())) {
                if (type == 1) {
                    try {
                        pk = message.getPrivateKey().toPublic();
                    }
                    catch (IllegalArgumentException iae) {
                        if (this._log.shouldLog(40)) {
                            this._log.error("Bad private key in LS");
                        }
                        this._runner.disconnectClient("Bad private key in LS");
                        return;
                    }
                    if (!((PublicKey)pk).equals(ls.getEncryptionKey())) {
                        if (this._log.shouldLog(40)) {
                            this._log.error("Private/public crypto key mismatch in LS");
                        }
                        this._runner.disconnectClient("Private/public crypto key mismatch in LS");
                        return;
                    }
                    this._context.keyManager().registerKeys(dest, message.getSigningPrivateKey(), message.getPrivateKey());
                } else {
                    LeaseSet2 ls2 = (LeaseSet2)ls;
                    CreateLeaseSet2Message msg2 = (CreateLeaseSet2Message)message;
                    List<PublicKey> eks = ls2.getEncryptionKeys();
                    List<PrivateKey> pks = msg2.getPrivateKeys();
                    for (int i = 0; i < eks.size(); ++i) {
                        PublicKey pk2;
                        PublicKey ek = eks.get(i);
                        try {
                            pk2 = pks.get(i).toPublic();
                        }
                        catch (IllegalArgumentException iae) {
                            if (this._log.shouldLog(40)) {
                                this._log.error("Bad private key in LS: " + i);
                            }
                            this._runner.disconnectClient("Bad private key in LS: " + i);
                            return;
                        }
                        if (pk2.equals(ek)) continue;
                        if (this._log.shouldLog(40)) {
                            this._log.error("Private/public crypto key mismatch in LS for key: " + i);
                        }
                        this._runner.disconnectClient("Private/public crypto key mismatch in LS for key: " + i);
                        return;
                    }
                    this._context.keyManager().registerKeys(dest, message.getSigningPrivateKey(), pks);
                }
            } else if (message.getSigningPrivateKey() != null && !message.getSigningPrivateKey().equals(keys.getRevocationKey())) {
                this._context.keyManager().registerKeys(dest, message.getSigningPrivateKey(), message.getPrivateKey());
            }
        }
        try {
            Hash newHash;
            boolean ok;
            if (type == 5 && !(ok = this._runner.registerEncryptedLS(newHash = ls.getHash()))) {
                this._runner.disconnectClient("Duplicate hash of encrypted LS2");
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Publishing: " + String.valueOf(ls));
            }
            this._runner.getFloodfillNetworkDatabaseFacade().publish(ls);
            if (type == 5) {
                EncryptedLeaseSet encls = (EncryptedLeaseSet)ls;
                if (this._log.shouldDebug()) {
                    this._log.debug("Storing decrypted: " + String.valueOf(encls.getDecryptedLeaseSet()));
                }
                this._runner.getFloodfillNetworkDatabaseFacade().store(dest.getHash(), encls.getDecryptedLeaseSet());
            }
        }
        catch (IllegalArgumentException iae) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid leaseset from client", iae);
            }
            this._runner.disconnectClient("Invalid leaseset: " + String.valueOf(iae));
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("New lease set granted for destination " + String.valueOf(dest));
        }
        this._runner.leaseSetCreated(ls);
    }

    protected void handleDestLookup(DestLookupMessage message) {
        this._context.jobQueue().addJob(new LookupDestJob(this._context, this._runner, message.getHash(), this._runner.getDestHash()));
    }

    protected void handleHostLookup(HostLookupMessage message) {
        Hash h;
        SessionId sid = message.getSessionId();
        if (sid != null) {
            h = this._runner.getDestHash(sid);
        } else {
            if (message.getReqID() >= 0L) {
                sid = new SessionId(65535);
            }
            h = null;
        }
        if (h == null) {
            h = this._runner.getDestHash();
        }
        this._context.jobQueue().addJob(new LookupDestJob(this._context, this._runner, message.getReqID(), message.getTimeout(), sid, message.getHash(), message.getHostname(), h));
    }

    private void handleReconfigureSession(ReconfigureSessionMessage message) {
        SessionId id = message.getSessionId();
        SessionConfig cfg = this._runner.getConfig(id);
        if (cfg == null) {
            List<SessionId> current = this._runner.getSessionIds();
            String msg = "ReconfigureSession invalid session: " + String.valueOf(id) + " current: " + String.valueOf(current);
            if (this._log.shouldLog(40)) {
                this._log.error(msg);
            }
            this._runner.disconnectClient(msg);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Updating options - old: " + String.valueOf(cfg) + " new: " + String.valueOf(message.getSessionConfig()));
        }
        if (!message.getSessionConfig().getDestination().equals(cfg.getDestination())) {
            this._log.error("Dest mismatch");
            this.sendStatusMessage(id, 3);
            this._runner.stopRunning();
            return;
        }
        Hash dest = cfg.getDestination().calculateHash();
        cfg.getOptions().putAll((Map<?, ?>)message.getSessionConfig().getOptions());
        ClientTunnelSettings settings = new ClientTunnelSettings(dest);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)cfg.getOptions());
        settings.readFromProperties(props);
        this._context.tunnelManager().setInboundSettings(dest, settings.getInboundSettings());
        this._context.tunnelManager().setOutboundSettings(dest, settings.getOutboundSettings());
        this.sendStatusMessage(id, 2);
    }

    private void sendStatusMessage(SessionId id, int status) {
        block2: {
            SessionStatusMessage msg = new SessionStatusMessage();
            msg.setSessionId(id);
            msg.setStatus(status);
            try {
                this._runner.doSend(msg);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block2;
                this._log.warn("Error writing out the session status message", ime);
            }
        }
    }

    protected void handleGetBWLimits(GetBandwidthLimitsMessage message) {
        block3: {
            if (this._log.shouldLog(20)) {
                this._log.info("Got BW Limits request");
            }
            int in = this._context.bandwidthLimiter().getInboundKBytesPerSecond();
            int out = this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
            int inb = this._context.bandwidthLimiter().getInboundBurstKBytesPerSecond();
            int outb = this._context.bandwidthLimiter().getOutboundBurstKBytesPerSecond();
            BandwidthLimitsMessage msg = new BandwidthLimitsMessage(in * 2 / 3, out * 2 / 3, in, inb, out, outb, 1);
            try {
                this._runner.doSend(msg);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Error writing bw limits msg", ime);
            }
        }
    }

    private void handleBlindingInfo(BlindingInfoMessage message) {
        BlindData bd;
        if (this._log.shouldInfo()) {
            this._log.info("Got Blinding info");
        }
        if ((bd = message.getBlindData()) == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Unsupported BlindingInfo type: " + String.valueOf(message));
            }
            return;
        }
        SigningPublicKey spk = bd.getUnblindedPubKey();
        if (spk == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Unsupported BlindingInfo type: " + String.valueOf(message));
            }
            return;
        }
        BlindData obd = this._context.netDb().getBlindData(spk);
        if (obd == null) {
            this._context.netDb().setBlindData(bd);
            if (this._log.shouldWarn()) {
                this._log.warn("New: " + String.valueOf(bd));
            }
        } else {
            PrivateKey okey = obd.getAuthPrivKey();
            PrivateKey nkey = bd.getAuthPrivKey();
            String osec = obd.getSecret();
            String nsec = bd.getSecret();
            if (nkey != null && !nkey.equals(okey) || nsec != null && !nsec.equals(osec)) {
                if (obd.getDestination() != null && bd.getDestination() == null) {
                    try {
                        bd.setDestination(obd.getDestination());
                    }
                    catch (IllegalArgumentException iae) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Dest mismatch: " + String.valueOf(obd) + String.valueOf(bd), iae);
                        }
                        return;
                    }
                }
                this._context.netDb().setBlindData(bd);
                if (this._log.shouldWarn()) {
                    this._log.warn("Updated: " + String.valueOf(bd));
                }
            } else {
                long oexp = obd.getExpiration();
                long nexp = bd.getExpiration();
                if (nexp > oexp) {
                    obd.setExpiration(nexp);
                    this._context.netDb().setBlindData(obd);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Updated expiration: " + String.valueOf(obd));
                    }
                } else if (this._log.shouldWarn()) {
                    this._log.warn("No change: " + String.valueOf(obd));
                }
            }
        }
    }
}

