/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.elgamal;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.i2p.crypto.elgamal.ElGamalPrivateKey;
import net.i2p.crypto.elgamal.ElGamalPublicKey;
import net.i2p.crypto.elgamal.impl.ElGamalPrivateKeyImpl;
import net.i2p.crypto.elgamal.impl.ElGamalPublicKeyImpl;
import net.i2p.crypto.elgamal.spec.ElGamalParameterSpec;
import net.i2p.crypto.elgamal.spec.ElGamalPrivateKeySpec;
import net.i2p.crypto.elgamal.spec.ElGamalPublicKeySpec;

public final class KeyFactory
extends KeyFactorySpi {
    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ElGamalPrivateKeySpec) {
            return new ElGamalPrivateKeyImpl((ElGamalPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            return new ElGamalPrivateKeyImpl((PKCS8EncodedKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("key spec not recognised");
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ElGamalPublicKeySpec) {
            return new ElGamalPublicKeyImpl((ElGamalPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            return new ElGamalPublicKeyImpl((X509EncodedKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("key spec not recognised");
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        ElGamalPrivateKey k;
        ElGamalParameterSpec egp;
        if (keySpec.isAssignableFrom(ElGamalPublicKeySpec.class) && key instanceof ElGamalPublicKey) {
            ElGamalPublicKey k2 = (ElGamalPublicKey)key;
            ElGamalParameterSpec egp2 = k2.getParameters();
            if (egp2 != null) {
                return (T)new ElGamalPrivateKeySpec(k2.getY(), egp2);
            }
        } else if (keySpec.isAssignableFrom(ElGamalPrivateKeySpec.class) && key instanceof ElGamalPrivateKey && (egp = (k = (ElGamalPrivateKey)key).getParameters()) != null) {
            return (T)new ElGamalPrivateKeySpec(k.getX(), egp);
        }
        throw new InvalidKeySpecException("not implemented yet " + String.valueOf(key) + " " + String.valueOf(keySpec));
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("No other ElGamal key providers known");
    }
}

