/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties.effects;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.gui.effects.RadialGradientPainter;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.effects.PaintSupport;
import com.jeta.open.i18n.I18N;
import java.awt.Color;
import java.awt.Component;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RadialGradientProperty
extends JETAProperty
implements Externalizable,
PaintSupport {
    static final long serialVersionUID = 1554397018383485167L;
    public static final int VERSION = 1;
    public static final int TOP_LEFT = 0;
    public static final int TOP_CENTER = 1;
    public static final int TOP_RIGHT = 2;
    public static final int CENTER = 3;
    public static final int BOTTOM_LEFT = 4;
    public static final int BOTTOM_CENTER = 5;
    public static final int BOTTOM_RIGHT = 6;
    public static final int LEFT_CENTER = 7;
    public static final int RIGHT_CENTER = 8;
    private ColorProperty m_start_color = new ColorProperty(Color.black);
    private ColorProperty m_end_color = new ColorProperty(Color.white);
    private int m_position = 0;
    private int m_magnitude = 100;
    private transient RadialGradientPainter m_painter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RadialGradientProperty() {
    }

    public RadialGradientProperty(ColorProperty colorProperty, ColorProperty colorProperty2, int n, int n2) {
        this.m_start_color = colorProperty;
        this.m_end_color = colorProperty2;
        this.m_position = n;
        this.m_magnitude = n2;
    }

    public Painter createPainter() {
        if (this.m_painter == null) {
            this.m_painter = new RadialGradientPainter(this);
        }
        return this.m_painter;
    }

    public ColorProperty getStartColor() {
        return this.m_start_color;
    }

    public int getPosition() {
        return this.m_position;
    }

    public ColorProperty getEndColor() {
        return this.m_end_color;
    }

    public int getMagnitude() {
        return this.m_magnitude;
    }

    public void setMagnitude(int n) {
        this.m_magnitude = n;
        this.m_painter = null;
    }

    public void setPosition(int n) {
        this.m_position = n;
        this.m_painter = null;
    }

    public void setStartColor(ColorProperty colorProperty) {
        this.m_start_color = colorProperty;
        this.m_painter = null;
    }

    public void setEndColor(ColorProperty colorProperty) {
        this.m_end_color = colorProperty;
        this.m_painter = null;
    }

    public void setValue(Object object) {
        if (object instanceof RadialGradientProperty) {
            RadialGradientProperty radialGradientProperty = (RadialGradientProperty)object;
            if (this.m_start_color == null) {
                this.m_start_color = new ColorProperty();
            }
            if (this.m_end_color == null) {
                this.m_end_color = new ColorProperty();
            }
            this.m_start_color.setValue(radialGradientProperty.m_start_color);
            this.m_end_color.setValue(radialGradientProperty.m_end_color);
            this.m_position = radialGradientProperty.m_position;
            this.m_magnitude = radialGradientProperty.m_magnitude;
            this.m_painter = null;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jETABean) {
        RadialGradientPainter radialGradientPainter = (RadialGradientPainter)this.createPainter();
        if (jETABean != null) {
            Component component = jETABean.getDelegate();
            if (component instanceof Paintable) {
                ((Paintable)((Object)component)).setBackgroundPainter(radialGradientPainter);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    public String toString() {
        return I18N.getLocalizedMessage("Radial Gradient");
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.m_start_color = (ColorProperty)objectInput.readObject();
        this.m_end_color = (ColorProperty)objectInput.readObject();
        this.m_position = objectInput.readInt();
        this.m_magnitude = objectInput.readInt();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.m_start_color);
        objectOutput.writeObject(this.m_end_color);
        objectOutput.writeInt(this.m_position);
        objectOutput.writeInt(this.m_magnitude);
    }

    static {
        $assertionsDisabled = !RadialGradientProperty.class.desiredAssertionStatus();
    }
}

